/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.densityfunction;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public abstract class LazilyCachedDensityFunctionSeedifier
implements DensityFunction.Visitor {
    private static final ThreadLocal<Map<WorldGeneratorEntry, LazilyCachedDensityFunctionSeedifier>> visitorCache = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<Map<ResourceKey<NormalNoise.NoiseParameters>, DensityFunction.NoiseHolder>> holderCache = ThreadLocal.withInitial(HashMap::new);

    public static DensityFunction.Visitor getOrCreate(WorldGenLevel worldGenLevel) {
        return visitorCache.get().computeIfAbsent(new WorldGeneratorEntry(worldGenLevel.getSeed(), worldGenLevel.dimensionType()), level -> {
            ChunkSource patt0$temp = worldGenLevel.getChunkSource();
            if (patt0$temp instanceof ServerChunkCache) {
                ServerChunkCache chunkCache = (ServerChunkCache)patt0$temp;
                return new RandomStateBasedDensityFunctionSeedifier(chunkCache.randomState());
            }
            return new FallbackDensityFunctionSeedifier(RandomSource.create((long)worldGenLevel.getSeed()));
        });
    }

    public static void clearCache() {
        visitorCache.get().clear();
    }

    public DensityFunction apply(DensityFunction densityFunction) {
        return densityFunction;
    }

    public DensityFunction.NoiseHolder visitNoise(DensityFunction.NoiseHolder noiseHolder) {
        NormalNoise.NoiseParameters noiseParameters = (NormalNoise.NoiseParameters)noiseHolder.noiseData().value();
        return this.holderCache.get().computeIfAbsent((ResourceKey<NormalNoise.NoiseParameters>)((ResourceKey)noiseHolder.noiseData().unwrapKey().orElseThrow()), resourceKey -> this.modifyNoiseHolder(noiseHolder, noiseParameters));
    }

    abstract DensityFunction.NoiseHolder modifyNoiseHolder(DensityFunction.NoiseHolder var1, NormalNoise.NoiseParameters var2);

    private record WorldGeneratorEntry(long seed, DimensionType dimensionType) {
    }

    private static class RandomStateBasedDensityFunctionSeedifier
    extends LazilyCachedDensityFunctionSeedifier {
        private final RandomState randomState;

        private RandomStateBasedDensityFunctionSeedifier(RandomState randomState) {
            this.randomState = randomState;
        }

        @Override
        DensityFunction.NoiseHolder modifyNoiseHolder(DensityFunction.NoiseHolder noiseHolder, NormalNoise.NoiseParameters noiseParameters) {
            return new DensityFunction.NoiseHolder(noiseHolder.noiseData(), this.randomState.getOrCreateNoise((ResourceKey)noiseHolder.noiseData().unwrapKey().orElseThrow()));
        }
    }

    private static final class FallbackDensityFunctionSeedifier
    extends LazilyCachedDensityFunctionSeedifier {
        private final RandomSource randomSource;

        private FallbackDensityFunctionSeedifier(RandomSource randomSource) {
            this.randomSource = randomSource;
        }

        @Override
        DensityFunction.NoiseHolder modifyNoiseHolder(DensityFunction.NoiseHolder noiseHolder, NormalNoise.NoiseParameters noiseParameters) {
            return new DensityFunction.NoiseHolder(noiseHolder.noiseData(), NormalNoise.create((RandomSource)this.randomSource, (NormalNoise.NoiseParameters)noiseParameters));
        }
    }
}

