/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature;

import com.farcr.nomansland.common.world.feature.CragRockFeatureConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class CragRockFeature
extends Feature<CragRockFeatureConfiguration> {
    private static final NormalNoise NOISE = NormalNoise.create((RandomSource)RandomSource.create((long)0L), (int)0, (double[])new double[]{1.0});

    public CragRockFeature(Codec<CragRockFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<CragRockFeatureConfiguration> context) {
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        CragRockFeatureConfiguration config = (CragRockFeatureConfiguration)context.config();
        int radius = config.radius().sample(random);
        int height = config.height().sample(random);
        double radiusStrength = config.radiusStrength().sample(random);
        double noiseStrength = config.noiseStrength().sample(random);
        int range = Math.min(Mth.ceil((float)(radius + 3)), 8);
        int depth = Mth.ceil((float)radius);
        int noiseSampleOffset = random.nextIntBetweenInclusive(-1000, 1000);
        boolean placedBlock = false;
        BlockPos.MutableBlockPos pos = origin.mutable();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                int baseHeight = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, origin.getX() + x, origin.getZ() + z) - depth - 1;
                double topHeight = (double)(origin.getY() + height) + NOISE.getValue((double)pos.getX() * 0.05, (double)(1000 + noiseSampleOffset), (double)pos.getZ() * 0.05) * 2.0;
                double maxYDistance = topHeight - (double)(baseHeight + depth);
                if ((double)baseHeight > topHeight) continue;
                int surfaceDepth = 0;
                double soilDepth = 2.0 + NOISE.getValue((double)pos.getX() * 0.05, (double)(2000 + noiseSampleOffset), (double)pos.getZ() * 0.05) * 1.5;
                boolean placingSurface = false;
                for (int y = Mth.ceil((double)topHeight); y >= baseHeight; --y) {
                    double radiusFac;
                    pos.set(x + origin.getX(), y, z + origin.getZ());
                    double noiseFac = NOISE.getValue((double)pos.getX() * 0.15, (double)pos.getY() * 0.02 + (double)noiseSampleOffset, (double)pos.getZ() * 0.15);
                    double xzDist = origin.distToCenterSqr((double)pos.getX() + 0.5, (double)origin.getY() + 0.5, (double)pos.getZ() + 0.5);
                    double yDist = y - (baseHeight + depth);
                    if (yDist > 1.0) {
                        double radiusMultiplier = Mth.clampedMap((double)yDist, (double)0.0, (double)(maxYDistance - 1.0), (double)1.0, (double)0.7);
                        double dist = Math.sqrt(origin.distToCenterSqr((double)pos.getX() + 0.5, (double)origin.getY() + 0.5, (double)pos.getZ() + 0.5));
                        radiusFac = (double)radius * (radiusMultiplier *= Mth.clampedMap((double)yDist, (double)(maxYDistance - 2.0), (double)maxYDistance, (double)1.0, (double)0.8)) - dist;
                    } else {
                        double dist = Math.sqrt(xzDist + yDist);
                        radiusFac = (double)(radius + 1) - dist;
                    }
                    if (radiusFac * radiusStrength + noiseFac * noiseStrength > 0.0) {
                        if ((yDist > maxYDistance * 0.75 || yDist < 2.0) && surfaceDepth == 0 && yDist > 0.0) {
                            placingSurface = true;
                        }
                        level.setBlock((BlockPos)pos, this.getBlockState(config, (BlockPos)pos, level, random, surfaceDepth, soilDepth, placingSurface), 2);
                        placedBlock = true;
                        ++surfaceDepth;
                        continue;
                    }
                    placingSurface = false;
                    surfaceDepth = 0;
                }
            }
        }
        return placedBlock;
    }

    private BlockState getBlockState(CragRockFeatureConfiguration config, BlockPos pos, WorldGenLevel level, RandomSource random, int surfaceDepth, double soilDepth, boolean placingSurface) {
        if (placingSurface && level.getBlockState(pos).canBeReplaced()) {
            if (surfaceDepth == 0 && (config.generateSurfaceUnderwater() || level.getBlockState(pos.above()).getFluidState().isEmpty())) {
                return config.surfaceBlockProvider().getState(random, pos);
            }
            if ((double)surfaceDepth < soilDepth) {
                return config.soilBlockProvider().getState(random, pos);
            }
        }
        return config.baseBlockProvider().getState(random, pos);
    }
}

