/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature;

import com.farcr.nomansland.common.world.feature.DitheredPatchFeatureConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class DitheredPatchFeature
extends Feature<DitheredPatchFeatureConfiguration> {
    private static final float[] DITHER_MATRIX = new float[]{0.0f, 0.5f, 0.125f, 0.625f, 0.75f, 0.25f, 0.875f, 0.375f, 0.1875f, 0.6875f, 0.0625f, 0.5625f, 0.9375f, 0.4375f, 0.8125f, 0.3125f};
    private static final NormalNoise NOISE = NormalNoise.create((RandomSource)RandomSource.create((long)0L), (int)0, (double[])new double[]{1.0});

    public DitheredPatchFeature(Codec<DitheredPatchFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<DitheredPatchFeatureConfiguration> context) {
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        DitheredPatchFeatureConfiguration config = (DitheredPatchFeatureConfiguration)context.config();
        BlockPos.MutableBlockPos mutableBlockPos = origin.mutable();
        int radius = config.radius().sample(random);
        int depth = config.depth().sample(random);
        float radiusStrength = config.radiusStrength().sample(random);
        float noiseStrength = config.noiseStrength().sample(random);
        float ditherStrength = config.ditherStrength().sample(random);
        BlockPredicate targetPredicate = config.target();
        BlockStateProvider blockProvider = config.blockProvider();
        float maxValue = (float)radius * radiusStrength + noiseStrength + 0.9375f * ditherStrength;
        boolean placedBlock = false;
        int range = Math.min(radius + 4, 8);
        for (int xOffset = -range; xOffset <= range; ++xOffset) {
            for (int zOffset = -range; zOffset <= range; ++zOffset) {
                float ditherFac;
                double noiseFac;
                int z;
                int y;
                int x = origin.getX() + xOffset;
                double radiusFac = (double)radius - Math.sqrt(origin.distToCenterSqr((double)x, (double)(y = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z = origin.getZ() + zOffset) - 1), (double)z));
                double facUndithered = radiusFac * (double)radiusStrength + (noiseFac = NOISE.getValue((double)x * 0.2, 0.0, (double)z * 0.2)) * (double)noiseStrength;
                double fac = facUndithered + (double)((ditherFac = DITHER_MATRIX[Math.floorMod(x, 4) * 4 + Math.floorMod(z, 4)] - 0.5f) * ditherStrength);
                if (!(fac > 0.0)) continue;
                int depthAtPos = Math.max(1, Mth.ceil((double)((double)depth * Math.clamp(facUndithered / ((double)maxValue * 0.3), 0.0, 1.0))));
                for (int yOffset = 0; yOffset < depthAtPos; ++yOffset) {
                    mutableBlockPos.set(x, y - yOffset, z);
                    if (!targetPredicate.test((Object)level, (Object)mutableBlockPos)) continue;
                    level.setBlock((BlockPos)mutableBlockPos, blockProvider.getState(random, (BlockPos)mutableBlockPos), 2);
                    placedBlock = true;
                }
            }
        }
        return placedBlock;
    }
}

