/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.decorator;

import com.farcr.nomansland.common.registry.worldgen.NMLPondDecoratorTypes;
import com.farcr.nomansland.common.world.feature.decorator.PondDecorator;
import com.farcr.nomansland.common.world.feature.decorator.PondDecoratorType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class FeatureClusterPondDecorator
extends PondDecorator {
    public static final MapCodec<FeatureClusterPondDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntProvider.CODEC.fieldOf("place_count").forGetter(f -> f.placeCount), (App)ExtraCodecs.POSITIVE_INT.fieldOf("tries").orElse((Object)128).forGetter(f -> f.tries), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("xz_spread").orElse((Object)7).forGetter(f -> f.xzSpread), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("y_spread").orElse((Object)3).forGetter(f -> f.ySpread), (App)PlacedFeature.LIST_CODEC.fieldOf("features").forGetter(f -> f.features)).apply((Applicative)instance, FeatureClusterPondDecorator::new));
    protected final IntProvider placeCount;
    protected final int tries;
    protected final int xzSpread;
    protected final int ySpread;
    protected final HolderSet<PlacedFeature> features;

    public FeatureClusterPondDecorator(IntProvider placeCount, int tries, int xzSpread, int ySpread, HolderSet<PlacedFeature> features) {
        this.placeCount = placeCount;
        this.tries = tries;
        this.xzSpread = xzSpread;
        this.ySpread = ySpread;
        this.features = features;
    }

    @Override
    protected PondDecoratorType<?> type() {
        return (PondDecoratorType)NMLPondDecoratorTypes.FEATURE_CLUSTER.get();
    }

    @Override
    public void place(PondDecorator.Context context) {
        RandomSource random = context.random();
        WorldGenLevel level = context.level();
        int count = 0;
        int limit = this.placeCount.sample(random);
        for (BlockPos pos : Util.shuffledCopy(context.water(), (RandomSource)random)) {
            if (count >= limit) break;
            BlockPos adj = this.getAdjacentGround((LevelReader)level, random, pos);
            if (adj == null) continue;
            ++count;
            BlockPos.MutableBlockPos pos1 = adj.mutable();
            for (int i = 0; i < this.tries; ++i) {
                int x = (int)((double)adj.getX() + random.nextGaussian() * (double)this.xzSpread);
                int z = (int)((double)adj.getZ() + random.nextGaussian() * (double)this.xzSpread);
                int y = adj.getY() + random.nextInt(-this.ySpread, this.ySpread);
                pos1.set(x, y, z);
                float distanceFromOriginXZ = Mth.sqrt((float)((x - adj.getX()) * (x - adj.getX()) + (z - adj.getZ()) * (z - adj.getZ())));
                distanceFromOriginXZ = (float)((double)distanceFromOriginXZ + (double)(random.nextFloat() * 2.0f - 1.0f) * 0.8);
                distanceFromOriginXZ = Mth.clamp((float)(distanceFromOriginXZ / (float)(this.xzSpread * 3)), (float)0.0f, (float)0.99f);
                int index = Mth.floor((float)(distanceFromOriginXZ * (float)this.features.size()));
                if (!((double)distanceFromOriginXZ < 24.0)) continue;
                ((PlacedFeature)this.features.get(index).value()).place(level, context.chunkGenerator(), random, (BlockPos)pos1);
            }
        }
    }

    private BlockPos getAdjacentGround(LevelReader level, RandomSource random, BlockPos pos) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos rel = pos.relative(dir).above();
            if (!level.getBlockState(rel.below()).isSolid() || !level.getBlockState(rel).is(BlockTags.REPLACEABLE)) continue;
            validPositions.add(rel);
        }
        if (validPositions.isEmpty()) {
            return null;
        }
        return (BlockPos)validPositions.get(random.nextInt(validPositions.size()));
    }
}

