/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.decorator;

import com.farcr.nomansland.common.registry.worldgen.NMLTreeDecoratorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class FruitLeavesDecorator
extends TreeDecorator {
    public static final MapCodec<FruitLeavesDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(f -> Float.valueOf(f.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(f -> f.exclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("limit").forGetter(f -> f.limit), (App)BlockStateProvider.CODEC.fieldOf("leaves_provider").forGetter(f -> f.leavesProvider), (App)BlockStateProvider.CODEC.fieldOf("fruit_provider").forGetter(f -> f.leavesProvider)).apply((Applicative)instance, FruitLeavesDecorator::new));
    protected final float probability;
    protected final int exclusionRadiusXZ;
    protected final int limit;
    protected final BlockStateProvider leavesProvider;
    protected final BlockStateProvider fruitProvider;

    public FruitLeavesDecorator(float probability, int exclusionRadiusXZ, int limit, BlockStateProvider leavesProvider, BlockStateProvider fruitProvider) {
        this.probability = probability;
        this.exclusionRadiusXZ = exclusionRadiusXZ;
        this.limit = limit;
        this.leavesProvider = leavesProvider;
        this.fruitProvider = fruitProvider;
    }

    public void place(TreeDecorator.Context context) {
        HashSet<BlockPos> excludedPositions = new HashSet<BlockPos>();
        int leaves = 0;
        RandomSource randomsource = context.random();
        if (randomsource.nextFloat() < this.probability) {
            for (BlockPos blockpos : Util.shuffledCopy((ObjectArrayList)context.leaves(), (RandomSource)randomsource)) {
                if (!excludedPositions.contains(blockpos) && context.isAir(blockpos.below())) {
                    BlockPos blockpos2 = blockpos.offset(-this.exclusionRadiusXZ, 0, -this.exclusionRadiusXZ);
                    BlockPos blockpos3 = blockpos.offset(this.exclusionRadiusXZ, 0, this.exclusionRadiusXZ);
                    for (BlockPos blockpos4 : BlockPos.betweenClosed((BlockPos)blockpos2, (BlockPos)blockpos3)) {
                        excludedPositions.add(blockpos4.immutable());
                    }
                    context.setBlock(blockpos, this.leavesProvider.getState(randomsource, blockpos));
                    context.setBlock(blockpos.below(), this.fruitProvider.getState(randomsource, blockpos.below()));
                    ++leaves;
                }
                if (leaves <= this.limit) continue;
                break;
            }
        }
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)NMLTreeDecoratorTypes.FRUIT_LEAVES.get();
    }
}

