/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.foliageplacer;

import com.farcr.nomansland.common.registry.worldgen.NMLFoliagePlacerTypes;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import org.jetbrains.annotations.NotNull;

public class CypressFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CypressFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CypressFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CypressFoliagePlacer::new));

    public CypressFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)NMLFoliagePlacerTypes.CYPRESS_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(@NotNull LevelSimulatedReader level, @NotNull FoliagePlacer.FoliageSetter blockSetter, @NotNull RandomSource random, @NotNull TreeConfiguration config, int maxFreeTreeHeight, @NotNull FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int foliageOffset) {
        for (int i = foliageOffset; i >= foliageOffset - 1; --i) {
            int radius = foliageRadius + attachment.radiusOffset() - (i == foliageOffset ? 1 : 0);
            this.placeLeavesRow(level, blockSetter, random, config, attachment.pos(), radius, i, attachment.doubleTrunk());
        }
    }

    public int foliageHeight(@NotNull RandomSource random, int height, @NotNull TreeConfiguration config) {
        return height;
    }

    protected boolean shouldSkipLocation(@NotNull RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range;
    }
}

