/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.placementmodifier;

import com.farcr.nomansland.common.registry.worldgen.NMLPlacementModifiers;
import com.farcr.nomansland.common.world.densityfunction.LazilyCachedDensityFunctionSeedifier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class DensityFunctionBasedProbabilityPlacement
extends PlacementModifier {
    public static final MapCodec<DensityFunctionBasedProbabilityPlacement> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("noise_function").forGetter(instance -> instance.densityFunction), (App)Codec.DOUBLE.fieldOf("noise_scale").orElse((Object)1.0).forGetter(instance -> instance.noiseScale), (App)Codec.DOUBLE.fieldOf("noise_minimum").orElse((Object)0.0).forGetter(instance -> instance.noiseMinimum), (App)Codec.DOUBLE.fieldOf("noise_maximum").orElse((Object)1.0).forGetter(instance -> instance.noiseMaximum), (App)Codec.DOUBLE.fieldOf("probability_minimum").orElse((Object)0.0).forGetter(instance -> instance.probabilityMinimum), (App)Codec.DOUBLE.fieldOf("probability_maximum").orElse((Object)1.0).forGetter(instance -> instance.probabilityMaximum), (App)Codec.BOOL.fieldOf("clamped").orElse((Object)true).forGetter(instance -> instance.clamped)).apply((Applicative)codec, DensityFunctionBasedProbabilityPlacement::new));
    private final DensityFunction densityFunction;
    private final double noiseScale;
    private final double noiseMinimum;
    private final double noiseMaximum;
    private final double probabilityMinimum;
    private final double probabilityMaximum;
    private final boolean clamped;

    public DensityFunctionBasedProbabilityPlacement(DensityFunction densityFunction, double noiseScale, double noiseMinimum, double noiseMaximum, double probabilityMinimum, double probabilityMaximum, boolean clamped) {
        this.densityFunction = densityFunction;
        this.noiseScale = noiseScale;
        this.noiseMinimum = noiseMinimum;
        this.noiseMaximum = noiseMaximum;
        this.probabilityMinimum = probabilityMinimum;
        this.probabilityMaximum = probabilityMaximum;
        this.clamped = clamped;
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        DensityFunction seedifiedDensityFunction = this.densityFunction.mapAll(LazilyCachedDensityFunctionSeedifier.getOrCreate(context.getLevel()));
        double threshold = seedifiedDensityFunction.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext((int)((double)pos.getX() * this.noiseScale), (int)((double)pos.getY() * this.noiseScale), (int)((double)pos.getZ() * this.noiseScale)));
        threshold = this.clamped ? Mth.clampedMap((double)threshold, (double)this.noiseMinimum, (double)this.noiseMaximum, (double)this.probabilityMinimum, (double)this.probabilityMaximum) : Mth.map((double)threshold, (double)this.noiseMinimum, (double)this.noiseMaximum, (double)this.probabilityMinimum, (double)this.probabilityMaximum);
        return random.nextDouble() < threshold ? Stream.of(pos) : Stream.empty();
    }

    public PlacementModifierType<?> type() {
        return NMLPlacementModifiers.DENSITY_FUNCTION_BASED_PROBABILITY.get();
    }
}

