/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.placementmodifier;

import com.farcr.nomansland.common.registry.worldgen.NMLPlacementModifiers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class HeightFilterPlacement
extends PlacementFilter {
    public static final MapCodec<HeightFilterPlacement> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.INT.fieldOf("height_min").orElse((Object)-1000000).forGetter(instance -> instance.minimumHeight), (App)Codec.INT.fieldOf("height_max").orElse((Object)1000000).forGetter(instance -> instance.maximumHeight)).apply((Applicative)codec, HeightFilterPlacement::new));
    private final int minimumHeight;
    private final int maximumHeight;

    public HeightFilterPlacement(int minimumHeight, int maximumHeight) {
        this.minimumHeight = minimumHeight;
        this.maximumHeight = maximumHeight;
    }

    protected boolean shouldPlace(PlacementContext context, RandomSource random, BlockPos pos) {
        return pos.getY() >= this.minimumHeight && pos.getY() <= this.maximumHeight;
    }

    public PlacementModifierType<?> type() {
        return NMLPlacementModifiers.HEIGHT_FILTER.get();
    }
}

