/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.structure.processor;

import com.farcr.nomansland.common.registry.worldgen.NMLStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class TallBlockRemoverProcessor
extends StructureProcessor {
    public static final MapCodec<TallBlockRemoverProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(prefixProcessor -> prefixProcessor.block), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(prefixProcessor -> Float.valueOf(prefixProcessor.chance))).apply((Applicative)instance, TallBlockRemoverProcessor::new));
    private final float chance;
    private final Block block;

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)NMLStructureProcessorTypes.TALL_BLOCK_REMOVER.get();
    }

    public TallBlockRemoverProcessor(Block block, float chance) {
        this.block = block;
        this.chance = chance;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader levelReader, BlockPos offset, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        BlockState state = relativeBlockInfo.state();
        if (state.is(this.block) && state.hasProperty((Property)DoublePlantBlock.HALF) && state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER && settings.getRandom(relativeBlockInfo.pos()).nextFloat() < this.chance) {
            return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.pos(), (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), relativeBlockInfo.nbt());
        }
        return relativeBlockInfo;
    }

    public List<StructureTemplate.StructureBlockInfo> finalizeProcessing(ServerLevelAccessor serverLevel, BlockPos offset, BlockPos pos, List<StructureTemplate.StructureBlockInfo> originalBlockInfos, List<StructureTemplate.StructureBlockInfo> processedBlockInfos, StructurePlaceSettings settings) {
        ArrayList<StructureTemplate.StructureBlockInfo> finalBlockInfos = new ArrayList<StructureTemplate.StructureBlockInfo>(List.copyOf(processedBlockInfos));
        block0: for (StructureTemplate.StructureBlockInfo blockInfo : processedBlockInfos) {
            BlockState state = blockInfo.state();
            if (!state.is(this.block) || !state.hasProperty((Property)DoublePlantBlock.HALF) || state.getValue((Property)DoublePlantBlock.HALF) != DoubleBlockHalf.UPPER) continue;
            for (StructureTemplate.StructureBlockInfo blockInfo1 : processedBlockInfos) {
                if (!blockInfo.pos().equals((Object)blockInfo1.pos().above()) || blockInfo1.state().is(this.block)) continue;
                finalBlockInfos.remove(blockInfo);
                finalBlockInfos.add(new StructureTemplate.StructureBlockInfo(blockInfo.pos(), Blocks.AIR.defaultBlockState(), blockInfo.nbt()));
                continue block0;
            }
        }
        return finalBlockInfos;
    }
}

