/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen;

import com.farcr.nomansland.common.definitions.BlockDefinition;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.datagen.loot.BlockLootType;
import com.farcr.nomansland.datagen.loot.BookshelfBlockLootType;
import com.farcr.nomansland.datagen.loot.CandleCakeBlockLootType;
import com.farcr.nomansland.datagen.loot.CustomBlockLootType;
import com.farcr.nomansland.datagen.loot.DoorBlockLootType;
import com.farcr.nomansland.datagen.loot.FlowerPotBlockLootType;
import com.farcr.nomansland.datagen.loot.OtherBlockLootType;
import com.farcr.nomansland.datagen.loot.OtherShearsBlockLootType;
import com.farcr.nomansland.datagen.loot.SelfBlockLootType;
import com.farcr.nomansland.datagen.loot.ShearsBlockLootType;
import com.farcr.nomansland.datagen.loot.SlabBlockLootType;
import java.util.HashSet;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class NMLBlockLootSubProvider
extends BlockLootSubProvider {
    private final HolderLookup.Provider provider;

    public NMLBlockLootSubProvider(HolderLookup.Provider provider) {
        super(new HashSet(), FeatureFlags.REGISTRY.allFlags(), provider);
        this.provider = provider;
    }

    protected Iterable<Block> getKnownBlocks() {
        return NMLBlocks.BLOCK_DEFINITIONS.stream().filter(blockDefinition -> !(blockDefinition.lootType() instanceof CustomBlockLootType)).map(BlockDefinition::block).toList();
    }

    protected void generate() {
        for (BlockDefinition<?> definition : NMLBlocks.BLOCK_DEFINITIONS) {
            Block block = (Block)definition.get();
            BlockLootType lootType = definition.lootType();
            if (lootType instanceof SelfBlockLootType) {
                this.dropSelf(block);
                continue;
            }
            if (lootType instanceof OtherBlockLootType) {
                OtherBlockLootType otherBlockLootType = (OtherBlockLootType)lootType;
                this.add(block, this.createSingleItemTable(otherBlockLootType.getBlock()));
                continue;
            }
            if (lootType instanceof ShearsBlockLootType) {
                this.add(block, NMLBlockLootSubProvider.createShearsOnlyDrop((ItemLike)block));
                continue;
            }
            if (lootType instanceof OtherShearsBlockLootType) {
                OtherShearsBlockLootType otherShearsBlockLootType = (OtherShearsBlockLootType)lootType;
                this.add(block, NMLBlockLootSubProvider.createShearsOnlyDrop((ItemLike)otherShearsBlockLootType.getBlock()));
                continue;
            }
            if (lootType instanceof SlabBlockLootType) {
                this.add(block, this.createSlabItemTable(block));
                continue;
            }
            if (lootType instanceof DoorBlockLootType) {
                this.add(block, this.createDoorTable(block));
                continue;
            }
            if (lootType instanceof CandleCakeBlockLootType) {
                CandleCakeBlockLootType candleCakeBlockLootType = (CandleCakeBlockLootType)lootType;
                this.add(block, NMLBlockLootSubProvider.createCandleCakeDrops((Block)candleCakeBlockLootType.getCandle()));
                continue;
            }
            if (lootType instanceof FlowerPotBlockLootType) {
                FlowerPotBlockLootType flowerPotBlockLootType = (FlowerPotBlockLootType)lootType;
                this.add(block, this.createPotFlowerItemTable(flowerPotBlockLootType.getPlant()));
                continue;
            }
            if (!(lootType instanceof BookshelfBlockLootType)) continue;
            this.add(block, NMLBlockLootSubProvider.createSelfDropDispatchTable((Block)block, (LootItemCondition.Builder)this.hasSilkTouch(), (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.BOOK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)3.0f)))))));
        }
    }
}

