/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen.tags;

import com.farcr.nomansland.common.definitions.BlockDefinition;
import com.farcr.nomansland.common.definitions.ItemDefinition;
import com.farcr.nomansland.common.integration.BlueprintIntegration;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.items.NMLItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class NMLItemTagsProvider
extends ItemTagsProvider {
    public NMLItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "nomansland", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (BlockDefinition<?> blockDefinition : NMLBlocks.BLOCK_DEFINITIONS) {
            if (!blockDefinition.hasItem()) continue;
            if (blockDefinition.get() instanceof FlowerBlock) {
                this.tag(ItemTags.SMALL_FLOWERS).add((Object)blockDefinition.item());
            }
            if (blockDefinition.get() instanceof WallBlock) {
                this.tag(ItemTags.WALLS).add((Object)blockDefinition.item());
            }
            if (blockDefinition.get() instanceof SaplingBlock) {
                this.tag(ItemTags.SAPLINGS).add((Object)blockDefinition.item());
            }
            if (blockDefinition.get() instanceof LeavesBlock) {
                this.tag(ItemTags.LEAVES).add((Object)blockDefinition.item());
            }
            if (!(blockDefinition.get() instanceof SlabBlock)) continue;
            this.tag(ItemTags.SLABS).add((Object)blockDefinition.item());
        }
        for (ItemDefinition itemDefinition : NMLItems.ITEM_DEFINITIONS) {
            if (!itemDefinition.hasItem() || !(itemDefinition.get() instanceof BoatItem)) continue;
            this.tag(ItemTags.BOATS).add((Object)itemDefinition.item());
        }
        for (NMLBlocks.Woodset woodset : NMLBlocks.WOODSETS) {
            this.tag(ItemTags.SIGNS).add((Object)woodset.sign().item());
            this.tag(ItemTags.HANGING_SIGNS).add((Object)woodset.hangingSign().item());
            this.tag(ItemTags.PLANKS).add((Object)woodset.planks().item());
            this.tag(ItemTags.PLANKS).add((Object)woodset.trimmedPlanks().item());
            this.tag(NMLTags.BOOKSHELVES.itemTag()).add((Object)woodset.bookshelf().item());
            this.tag(Tags.Items.FENCE_GATES_WOODEN).add((Object)woodset.fenceGate().item());
            this.tag(Tags.Items.FENCES_WOODEN).add((Object)woodset.fence().item());
            this.tag(ItemTags.WOODEN_FENCES).add((Object)woodset.fence().item());
            this.tag(ItemTags.WOODEN_STAIRS).add((Object)woodset.stairs().item());
            this.tag(ItemTags.WOODEN_BUTTONS).add((Object)woodset.button().item());
            this.tag(ItemTags.WOODEN_DOORS).add((Object)woodset.door().item());
            this.tag(ItemTags.WOODEN_SLABS).add((Object)woodset.slab().item());
            this.tag(ItemTags.WOODEN_PRESSURE_PLATES).add((Object)woodset.pressurePlate().item());
            this.tag(ItemTags.WOODEN_TRAPDOORS).add((Object)woodset.trapdoor().item());
            this.tag(ItemTags.LOGS).add((Object)woodset.log().item());
            this.tag(Tags.Items.STRIPPED_LOGS).add((Object)woodset.strippedLog().item());
            this.tag(Tags.Items.STRIPPED_WOODS).add((Object)woodset.strippedWood().item());
        }
        this.tag(NMLTags.BOOKSHELVES.itemTag()).add((Object[])new Item[]{NMLBlocks.ACACIA_BOOKSHELF.item(), NMLBlocks.BAMBOO_BOOKSHELF.item(), NMLBlocks.BIRCH_BOOKSHELF.item(), NMLBlocks.CHERRY_BOOKSHELF.item(), NMLBlocks.CRIMSON_BOOKSHELF.item(), NMLBlocks.DARK_OAK_BOOKSHELF.item(), NMLBlocks.JUNGLE_BOOKSHELF.item(), NMLBlocks.MANGROVE_BOOKSHELF.item(), NMLBlocks.SPRUCE_BOOKSHELF.item(), NMLBlocks.WARPED_BOOKSHELF.item()});
        this.addToTags(NMLTags.BOOKSHELVES.itemTag(), Tags.Items.BOOKSHELVES, BlueprintIntegration.woodenBookshelves().itemTag());
        this.tag(ItemTags.PLANKS).addTag(NMLTags.TRIMMED_PLANKS.itemTag());
        this.tag(ItemTags.LOGS_THAT_BURN).addTags(new TagKey[]{NMLTags.MAPLE_LOGS.itemTag(), NMLTags.PINE_LOGS.itemTag(), NMLTags.WALNUT_LOGS.itemTag(), NMLTags.WILLOW_LOGS.itemTag()});
    }

    @SafeVarargs
    protected final void addToTags(Item item, TagKey<Item> ... itemTags) {
        List.of(itemTags).forEach(itemTag -> this.tag((TagKey)itemTag).add((Object)item));
    }

    @SafeVarargs
    protected final void addToTags(TagKey<Item> item, TagKey<Item> ... itemTags) {
        List.of(itemTags).forEach(itemTag -> this.tag((TagKey)itemTag).addTag(item));
    }
}

