/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen.worldgen;

import com.farcr.nomansland.NoMansLand;
import com.farcr.nomansland.common.world.biomemodifiers.ChangeColorsBiomeModifier;
import com.farcr.nomansland.common.world.biomemodifiers.ChangeMusicBiomeModifier;
import com.farcr.nomansland.common.world.biomemodifiers.ChangeParticleBiomeModifier;
import com.farcr.nomansland.common.world.biomemodifiers.ChangeSpawnsBiomeModifier;
import com.farcr.nomansland.datagen.worldgen.FeatureWithStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class BiomeModifierBuilder {
    private final String name;
    private final HolderSet<Biome> biome;
    private final BootstrapContext<BiomeModifier> bootstrap;
    private ChangeColorsBiomeModifier changeColors = null;
    private ChangeMusicBiomeModifier changeMusic = null;
    private ChangeParticleBiomeModifier changeParticle = null;
    private final List<FeatureWithStep> addedFeatures = new ArrayList<FeatureWithStep>();
    private BiomeModifiers.RemoveFeaturesBiomeModifier removeFeatures = null;
    private ChangeSpawnsBiomeModifier changeSpawns = null;
    private BiomeModifiers.AddSpawnsBiomeModifier addSpawns = null;
    private BiomeModifiers.RemoveSpawnsBiomeModifier removeSpawns = null;

    public BiomeModifierBuilder(BootstrapContext<BiomeModifier> bootstrap, ResourceKey<Biome> key) {
        this.bootstrap = bootstrap;
        this.name = key.location().getPath();
        this.biome = HolderSet.direct((Holder[])new Holder[]{bootstrap.lookup(Registries.BIOME).getOrThrow(key)});
    }

    public final BiomeModifierBuilder changeColors(int fogColor, int waterColor, int waterFogColor, int skyColor, int grassColor, int foliageColor) {
        this.changeColors = new ChangeColorsBiomeModifier(this.biome, fogColor, waterColor, waterFogColor, skyColor, grassColor, foliageColor);
        return this;
    }

    public final BiomeModifierBuilder changeColors(int fogColor, int waterColor, int waterFogColor, int skyColor, int foliageColor) {
        this.changeColors = new ChangeColorsBiomeModifier(this.biome, fogColor, waterColor, waterFogColor, skyColor, foliageColor);
        return this;
    }

    public final BiomeModifierBuilder changeColors(int fogColor, int waterColor, int waterFogColor, int skyColor) {
        this.changeColors = new ChangeColorsBiomeModifier(this.biome, fogColor, waterColor, waterFogColor, skyColor);
        return this;
    }

    public final BiomeModifierBuilder changeMusic(Music music) {
        this.changeMusic = new ChangeMusicBiomeModifier(this.biome, music);
        return this;
    }

    public final BiomeModifierBuilder changeParticle(ParticleOptions particle, float probability) {
        this.changeParticle = new ChangeParticleBiomeModifier(this.biome, new AmbientParticleSettings(particle, probability));
        return this;
    }

    public final BiomeModifierBuilder addFeatures(List<FeatureWithStep> features) {
        this.addedFeatures.addAll(features);
        return this;
    }

    public final BiomeModifierBuilder addFeatures(FeatureWithStep ... features) {
        this.addedFeatures.addAll(List.of(features));
        return this;
    }

    @SafeVarargs
    public final BiomeModifierBuilder removeFeatures(ResourceKey<PlacedFeature> ... features) {
        ArrayList featureHolders = new ArrayList();
        List.of(features).forEach(featureKey -> featureHolders.add(this.bootstrap.lookup(Registries.PLACED_FEATURE).getOrThrow(featureKey)));
        this.removeFeatures = BiomeModifiers.RemoveFeaturesBiomeModifier.allSteps(this.biome, (HolderSet)HolderSet.direct(featureHolders));
        return this;
    }

    public final BiomeModifierBuilder changeSpawns(MobSpawnSettings.SpawnerData ... spawners) {
        this.changeSpawns = new ChangeSpawnsBiomeModifier(this.biome, List.of(spawners));
        return this;
    }

    public final BiomeModifierBuilder addSpawns(MobSpawnSettings.SpawnerData ... spawners) {
        this.addSpawns = new BiomeModifiers.AddSpawnsBiomeModifier(this.biome, List.of(spawners));
        return this;
    }

    public final BiomeModifierBuilder removeSpawns(EntityType<?> ... entityTypes) {
        ArrayList entityTypeHolders = new ArrayList();
        List.of(entityTypes).forEach(entityType -> entityTypeHolders.add(BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)EntityType.ZOMBIE)));
        this.removeSpawns = new BiomeModifiers.RemoveSpawnsBiomeModifier(this.biome, (HolderSet)HolderSet.direct(entityTypeHolders));
        return this;
    }

    public final void build(Map<FeatureWithStep, List<Holder<Biome>>> featureToBiomes) {
        if (!this.addedFeatures.isEmpty()) {
            this.addedFeatures.forEach(feature -> featureToBiomes.computeIfAbsent((FeatureWithStep)feature, f -> new ArrayList()).add(this.biome.get(0)));
        }
        if (this.changeColors != null) {
            this.bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NoMansLand.location(this.name + "/change_color")), (Object)this.changeColors);
        }
        if (this.changeMusic != null) {
            this.bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NoMansLand.location(this.name + "/change_music")), (Object)this.changeMusic);
        }
        if (this.changeParticle != null) {
            this.bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NoMansLand.location(this.name + "/change_particle")), (Object)this.changeParticle);
        }
        if (this.changeSpawns != null) {
            this.bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NoMansLand.location(this.name + "/change_spawns")), (Object)this.changeSpawns);
        }
        if (this.addSpawns != null) {
            this.bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NoMansLand.location(this.name + "/add_spawns")), (Object)this.addSpawns);
        }
        if (this.removeSpawns != null) {
            this.bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NoMansLand.location(this.name + "/remove_spawns")), (Object)this.removeSpawns);
        }
        if (this.removeFeatures != null) {
            this.bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NoMansLand.location(this.name + "/remove_features")), (Object)this.removeFeatures);
        }
    }
}

