/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.ambience;

import com.farcr.nomansland.client.ambience.AmbienceHandler;
import com.farcr.nomansland.client.ambience.WeatherState;
import com.farcr.nomansland.client.ambience.fogmodifiers.FogModifier;
import com.farcr.nomansland.client.ambience.fogmodifiers.FogModifierInstance;
import com.farcr.nomansland.common.registry.NMLRegistries;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME, modid="nomansland")
public class FogModifierHandler {
    private final List<FogModifierInstance> fogModifiers;
    private final FogContext context = new FogContext();
    private float fogStartMult = 1.0f;
    private float fogEndMult = 1.0f;
    private float fogStartAdd = 0.0f;
    private float fogEndAdd = 0.0f;
    private float pFogStartMult = 1.0f;
    private float pFogEndMult = 1.0f;
    private float pFogStartAdd = 0.0f;
    private float pFogEndAdd = 0.0f;
    private final Vector3f colorMult = new Vector3f(1.0f, 1.0f, 1.0f);
    private final Vector3f pColorMult = new Vector3f((Vector3fc)this.colorMult);
    private int ticksSinceLastUpdate = 0;
    private static final int TICKS_BETWEEN_UPDATES = 20;
    private final Vector3f returnColor = new Vector3f();

    public FogModifierHandler() {
        this.fogModifiers = new ArrayList<FogModifierInstance>();
    }

    public float getFogStartMultiplier(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.pFogStartMult, (float)this.fogStartMult);
    }

    public float getFogEndMultiplier(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.pFogEndMult, (float)this.fogEndMult);
    }

    public float getFogStartAddend(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.pFogStartAdd, (float)this.fogStartAdd);
    }

    public float getFogEndAddend(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.pFogEndAdd, (float)this.fogEndAdd);
    }

    public Vector3f getFogColorMultiplier(float partialTicks) {
        return this.pColorMult.lerp((Vector3fc)this.colorMult, partialTicks, this.returnColor);
    }

    public void fillFogModifiers() {
        NMLRegistries.FOG_MODIFIERS.holders().forEach(reference -> this.fogModifiers.add(new FogModifierInstance((FogModifier)reference.value())));
    }

    public void tick(ClientLevel level, Vec3 playerPos, float undergroundness) {
        Minecraft.getInstance().getProfiler().push("nomansland.fogModifierTick");
        this.tickModifierInterpolation();
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 20) {
            this.ticksSinceLastUpdate = 0;
            this.updateActiveModifiers(level, playerPos, undergroundness);
        }
        Minecraft.getInstance().getProfiler().pop();
    }

    protected void tickModifierInterpolation() {
        this.pFogStartMult = this.fogStartMult;
        this.pFogEndMult = this.fogEndMult;
        this.pFogStartAdd = this.fogStartAdd;
        this.pFogEndAdd = this.fogEndAdd;
        this.pColorMult.set((Vector3fc)this.colorMult);
        this.fogStartMult = 1.0f;
        this.fogEndMult = 1.0f;
        this.fogStartAdd = 0.0f;
        this.fogEndAdd = 0.0f;
        this.colorMult.set(1.0f, 1.0f, 1.0f);
        for (FogModifierInstance modifier : this.fogModifiers) {
            modifier.tick();
            if (!modifier.modifier.isEnabledWithFogType(Minecraft.getInstance().gameRenderer.getMainCamera().getFluidInCamera())) continue;
            this.fogStartMult *= modifier.getFogStartMultiplier();
            this.fogEndMult *= modifier.getFogEndMultiplier();
            this.fogStartAdd += modifier.getFogStartAddend();
            this.fogEndAdd += modifier.getFogEndAddend();
            modifier.multiplyFogColors(this.colorMult);
        }
    }

    protected void updateActiveModifiers(ClientLevel level, Vec3 playerPos, float undergroundness) {
        this.updateFogContext(level, playerPos, undergroundness);
        for (FogModifierInstance modifier : this.fogModifiers) {
            modifier.update(this.context);
        }
    }

    private void updateFogContext(ClientLevel level, Vec3 playerPos, float undergroundness) {
        BlockPos blockPos = BlockPos.containing((Position)playerPos);
        this.context.level = level;
        this.context.undergroundness = undergroundness;
        this.context.weather = WeatherState.fromWorld((Level)level, blockPos);
        this.context.playerPos.set(playerPos.x(), playerPos.y(), playerPos.z());
        this.context.biome = level.getBiome(blockPos);
        this.context.fluidType = Minecraft.getInstance().cameraEntity.getEyeInFluidType();
        Entity entity = Minecraft.getInstance().cameraEntity;
        if (entity instanceof LivingEntity) {
            MobEffectInstance effectInstance;
            LivingEntity entity2 = (LivingEntity)entity;
            this.context.blindnessFactor = entity2.hasEffect(MobEffects.BLINDNESS) ? ((effectInstance = entity2.getEffect(MobEffects.BLINDNESS)).isInfiniteDuration() ? 1.0f : Mth.lerp((float)Math.min(1.0f, (float)effectInstance.getDuration() / 20.0f), (float)0.0f, (float)1.0f)) : 0.0f;
            if (entity2.hasEffect(MobEffects.DARKNESS)) {
                effectInstance = entity2.getEffect(MobEffects.DARKNESS);
                this.context.darknessFactor = Mth.lerp((float)effectInstance.getBlendFactor(entity2, 1.0f), (float)0.0f, (float)1.0f);
            } else {
                this.context.darknessFactor = 0.0f;
            }
        } else {
            this.context.blindnessFactor = 0.0f;
            this.context.darknessFactor = 0.0f;
        }
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        float partialTicks = (float)event.getPartialTick();
        float startMul = AmbienceHandler.FOG_MODIFIER_HANDLER.getFogStartMultiplier(partialTicks);
        float endMul = AmbienceHandler.FOG_MODIFIER_HANDLER.getFogEndMultiplier(partialTicks);
        float renderDistance = (float)Minecraft.getInstance().options.getEffectiveRenderDistance() * 16.0f;
        float startAdd = AmbienceHandler.FOG_MODIFIER_HANDLER.getFogStartAddend(partialTicks) * renderDistance;
        float endAdd = AmbienceHandler.FOG_MODIFIER_HANDLER.getFogEndAddend(partialTicks) * renderDistance;
        if (startMul != 1.0f || endMul != 1.0f || startAdd != 0.0f || endAdd != 0.0f) {
            event.setCanceled(true);
            event.setNearPlaneDistance(event.getNearPlaneDistance() * startMul + startAdd);
            event.setFarPlaneDistance(event.getFarPlaneDistance() * endMul + endAdd);
        }
    }

    @SubscribeEvent
    public static void renderColor(ViewportEvent.ComputeFogColor event) {
        float partialTicks = (float)event.getPartialTick();
        Vector3f color = AmbienceHandler.FOG_MODIFIER_HANDLER.getFogColorMultiplier(partialTicks);
        float red = event.getRed();
        float green = event.getGreen();
        float blue = event.getBlue();
        float undergroundFactor = 1.0f - AmbienceHandler.SURFACE_AMBIENCE_HANDLER.getAboveGroundFactor(partialTicks);
        if ((double)undergroundFactor > 0.001 && event.getCamera().getFluidInCamera() == FogType.NONE) {
            ClientLevel level = Minecraft.getInstance().level;
            BiomeManager biomemanager = level.getBiomeManager();
            Vec3 biomePos = event.getCamera().getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
            Vec3 rawBiomeColor = CubicSampler.gaussianSampleVec3((Vec3)biomePos, (x, y, z) -> level.effects().getBrightnessDependentFogColor(Vec3.fromRGB24((int)((Biome)biomemanager.getNoiseBiomeAtQuart(x, y, z).value()).getFogColor()), 1.0f));
            red = Mth.lerp((float)undergroundFactor, (float)red, (float)((float)rawBiomeColor.x()));
            green = Mth.lerp((float)undergroundFactor, (float)green, (float)((float)rawBiomeColor.y()));
            blue = Mth.lerp((float)undergroundFactor, (float)blue, (float)((float)rawBiomeColor.z()));
        }
        event.setRed(red * color.x());
        event.setGreen(green * color.y());
        event.setBlue(blue * color.z());
    }

    public static class FogContext {
        private ClientLevel level;
        private Holder<Biome> biome;
        private float undergroundness;
        private WeatherState weather;
        private final Vector3d playerPos = new Vector3d();
        private float blindnessFactor = 0.0f;
        private float darknessFactor = 0.0f;
        private FluidType fluidType;

        public ClientLevel level() {
            return this.level;
        }

        public Holder<Biome> biome() {
            return this.biome;
        }

        public float undergroundness() {
            return this.undergroundness;
        }

        public WeatherState weather() {
            return this.weather;
        }

        public Vector3dc playerPos() {
            return this.playerPos;
        }

        public float blindnessFactor() {
            return this.blindnessFactor;
        }

        public float darknessFactor() {
            return this.darknessFactor;
        }

        public FluidType fluidType() {
            return this.fluidType;
        }
    }
}

