/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.ambience;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.joml.Vector3f;

public class SurfaceAmbience {
    private final Minecraft minecraft;
    private float aboveGroundFactor;
    private float prevAboveGroundFactor = 1.0f;
    private final BlockPos.MutableBlockPos samplePos = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos iteratorPos = new BlockPos.MutableBlockPos();

    public SurfaceAmbience(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void tick(boolean shouldUpdate) {
        int heightY;
        boolean aboveHeightMap;
        this.minecraft.getProfiler().push("nomansland.surfaceAmbienceTick");
        this.prevAboveGroundFactor = this.aboveGroundFactor;
        if (!shouldUpdate) {
            return;
        }
        ClientLevel level = this.minecraft.level;
        Camera camera = this.minecraft.gameRenderer.getMainCamera();
        Vector3f cameraLook = camera.getLookVector();
        boolean aboveGround = true;
        BlockHitResult cast = level.clip(new ClipContext(camera.getPosition(), camera.getPosition().add((double)(cameraLook.x * 8.0f), (double)(cameraLook.y * 8.0f), (double)(cameraLook.z * 8.0f)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        for (int i = 0; i < 3; ++i) {
            this.samplePos.set((Vec3i)cast.getBlockPos());
            int x = (int)(level.random.nextGaussian() * 5.0);
            int z = (int)(level.random.nextGaussian() * 5.0);
            this.samplePos.move(x, 2, z);
            if (!SurfaceAmbience.isSolidBlock((Level)level, (BlockPos)this.samplePos)) break;
        }
        boolean bl = aboveHeightMap = camera.getPosition().y > (double)(heightY = level.getHeight(Heightmap.Types.WORLD_SURFACE, this.samplePos.getX(), this.samplePos.getZ()));
        if (!aboveHeightMap) {
            int solidBlocksEncountered = 0;
            this.iteratorPos.set((Vec3i)this.samplePos);
            while (this.iteratorPos.getY() < heightY) {
                BlockState state = level.getBlockState((BlockPos)this.iteratorPos);
                if (state.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)this.iteratorPos) && state.blocksMotion() && state.canOcclude()) {
                    ++solidBlocksEncountered;
                }
                if (solidBlocksEncountered >= 12) {
                    aboveGround = false;
                    break;
                }
                this.iteratorPos.move(Direction.UP);
            }
        }
        float mixFactor = 0.015625f;
        this.aboveGroundFactor = this.aboveGroundFactor * (1.0f - mixFactor) + (aboveGround ? 1.0f : -1.0f) * mixFactor;
        this.minecraft.getProfiler().pop();
    }

    public float getAboveGroundFactor(double partialTick) {
        return (float)(Mth.lerp((double)partialTick, (double)this.prevAboveGroundFactor, (double)this.aboveGroundFactor) + 1.0) / 2.0f;
    }

    private static boolean isSolidBlock(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.isCollisionShapeFullBlock((BlockGetter)level, pos) && state.blocksMotion() && state.canOcclude();
    }
}

