/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.event;

import com.farcr.nomansland.common.block.FrostedGrassBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import net.neoforged.neoforge.client.model.data.ModelData;

@EventBusSubscriber(modid="nomansland", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void addSectionGeometryEvent(AddSectionGeometryEvent event) {
        BlockPos origin = event.getSectionOrigin();
        LevelChunk chunk = event.getLevel().getChunkAt(origin);
        LevelChunkSection section = chunk.getSection(chunk.getSectionIndex(origin.getY()));
        if (section.maybeHas(FrostedGrassAdditionalGeoRenderer.STATE_PREDICATE)) {
            event.addRenderer((AddSectionGeometryEvent.AdditionalSectionRenderer)new FrostedGrassAdditionalGeoRenderer(Minecraft.getInstance().getBlockRenderer(), RandomSource.create(), SectionPos.of((BlockPos)origin)));
        }
    }

    static class FrostedGrassAdditionalGeoRenderer
    implements AddSectionGeometryEvent.AdditionalSectionRenderer {
        private static final Predicate<BlockState> STATE_PREDICATE = state -> state.getOptionalValue((Property)FrostedGrassBlock.SNOWLOGGED).orElse(false);
        private static final BlockState SNOW_BLOCKSTATE = Blocks.SNOW.defaultBlockState();
        final RandomSource randomsource;
        final ModelBlockRenderer modelBlockRenderer;
        final BakedModel snowModel;
        final SectionPos sectionPos;

        FrostedGrassAdditionalGeoRenderer(BlockRenderDispatcher blockRenderer, RandomSource randomsource, SectionPos sectionPos) {
            this.randomsource = randomsource;
            this.modelBlockRenderer = blockRenderer.getModelRenderer();
            this.snowModel = blockRenderer.getBlockModel(SNOW_BLOCKSTATE);
            this.sectionPos = sectionPos;
        }

        public void render(AddSectionGeometryEvent.SectionRenderingContext context) {
            BlockAndTintGetter region = context.getRegion();
            PoseStack stack = context.getPoseStack();
            this.sectionPos.blocksInside().filter(pos -> STATE_PREDICATE.test(context.getRegion().getBlockState(pos))).forEach(pos -> this.drawSnow(stack, region, (BlockPos)pos, arg_0 -> ((AddSectionGeometryEvent.SectionRenderingContext)context).getOrCreateChunkBuffer(arg_0)));
        }

        private void drawSnow(PoseStack stack, BlockAndTintGetter region, BlockPos pos, Function<RenderType, VertexConsumer> consumer) {
            stack.pushPose();
            stack.translate((float)SectionPos.sectionRelative((int)pos.getX()), (float)SectionPos.sectionRelative((int)pos.getY()), (float)SectionPos.sectionRelative((int)pos.getZ()));
            this.modelBlockRenderer.tesselateWithAO(region, this.snowModel, SNOW_BLOCKSTATE, pos, stack, consumer.apply(RenderType.cutoutMipped()), true, this.randomsource, SNOW_BLOCKSTATE.getSeed(pos), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, RenderType.cutoutMipped());
            stack.popPose();
        }
    }
}

