/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.event;

import com.farcr.nomansland.client.NMLModelLayers;
import com.farcr.nomansland.client.ambience.AmbienceHandler;
import com.farcr.nomansland.client.model.BillhookBassModel;
import com.farcr.nomansland.client.model.BuriedModel;
import com.farcr.nomansland.client.model.GooseModel;
import com.farcr.nomansland.client.model.MooseModel;
import com.farcr.nomansland.client.model.deer.DeerModel;
import com.farcr.nomansland.client.particle.BubbleParticle;
import com.farcr.nomansland.client.particle.BubblePopParticle;
import com.farcr.nomansland.client.particle.CaveDustParticle;
import com.farcr.nomansland.client.particle.EmbersParticle;
import com.farcr.nomansland.client.particle.FallingParticle;
import com.farcr.nomansland.client.particle.FlameParticle;
import com.farcr.nomansland.client.particle.FluidFallingParticle;
import com.farcr.nomansland.client.particle.FluidLandParticle;
import com.farcr.nomansland.client.particle.FluidSplashingParticle;
import com.farcr.nomansland.client.particle.SculkAmbienceParticle;
import com.farcr.nomansland.client.renderer.BillhookBassRenderer;
import com.farcr.nomansland.client.renderer.DeerRenderer;
import com.farcr.nomansland.client.renderer.ExplosiveRenderer;
import com.farcr.nomansland.client.renderer.FirebombRenderer;
import com.farcr.nomansland.client.renderer.GooseRenderer;
import com.farcr.nomansland.client.renderer.MooseRenderer;
import com.farcr.nomansland.common.registry.NMLFluids;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;

@EventBusSubscriber(modid="nomansland", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetupEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        AmbienceHandler.FOG_MODIFIER_HANDLER.fillFogModifiers();
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)"entity/firebomb")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)"entity/explosive")));
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(NMLEntities.BILLHOOK_BASS.get(), BillhookBassRenderer::new);
        event.registerEntityRenderer(NMLEntities.DEER.get(), DeerRenderer::new);
        event.registerEntityRenderer(NMLEntities.GOOSE.get(), GooseRenderer::new);
        event.registerEntityRenderer(NMLEntities.MOOSE.get(), MooseRenderer::new);
        event.registerEntityRenderer(NMLEntities.FIREBOMB.get(), FirebombRenderer::new);
        event.registerEntityRenderer(NMLEntities.EXPLOSIVE.get(), ExplosiveRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(NMLModelLayers.MOOSE_LAYER, MooseModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.BURIED_LAYER, BuriedModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.BASS_LAYER, BillhookBassModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.DEER_LAYER, DeerModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.GOOSE_LAYER, GooseModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_RESIN_OIL = ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)"block/fluid/resin_oil");
            private static final ResourceLocation FLOWING_RESIN_OIL = ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)"block/fluid/flowing_resin_oil");

            public ResourceLocation getStillTexture() {
                return STILL_RESIN_OIL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_RESIN_OIL;
            }
        }, new FluidType[]{NMLFluids.RESIN_OIL_TYPE.get()});
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)NMLParticleTypes.PALE_CHERRY_LEAVES.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FallingParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.CAVE_DUST.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new CaveDustParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.RESIN_DROPLET.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidFallingParticle(clientLevel, d, e, f, sprites, NMLParticleTypes.RESIN_DROPLET_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.RESIN_DROPLET_FLAT.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidLandParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MAPLE_SYRUP_DROPLET.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidFallingParticle(clientLevel, d, e, f, sprites, NMLParticleTypes.MAPLE_SYRUP_DROPLET_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MAPLE_SYRUP_DROPLET_FLAT.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidLandParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.OIL.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidFallingParticle(clientLevel, d, e, f, sprites, NMLParticleTypes.OIL_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.OIL_SPLASH.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidSplashingParticle(clientLevel, d, e, f, g, h, i, sprites, NMLParticleTypes.OIL_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.OIL_FLAT.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidLandParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.RESIN_OIL_BUBBLE.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new BubbleParticle(clientLevel, d, e, f, g, h, i, sprites, NMLParticleTypes.RESIN_OIL_BUBBLE_POP));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.RESIN_OIL_BUBBLE_POP.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new BubblePopParticle(clientLevel, d, e, f, g, h, i, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.SCULK_AMBIENCE.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new SculkAmbienceParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MALEVOLENT_EMBERS.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new EmbersParticle(clientLevel, d, e, f, g, h, i, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MALEVOLENT_FLAME.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FlameParticle(clientLevel, d, e, f, g, h, i, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MILK_DROPLET.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidFallingParticle(clientLevel, d, e, f, sprites, NMLParticleTypes.MILK_DROPLET_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MILK_DROPLET_FLAT.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidLandParticle(clientLevel, d, e, f, sprites));
    }
}

