/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.renderer;

import com.farcr.nomansland.client.NMLModelLayers;
import com.farcr.nomansland.client.model.BillhookBassModel;
import com.farcr.nomansland.common.entity.billhook_bass.BillhookBass;
import com.farcr.nomansland.common.entity.billhook_bass.BillhookBassVariant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tazer.mixed_litter.MLRegistries;
import dev.tazer.mixed_litter.VariantUtil;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BillhookBassRenderer
extends MobRenderer<BillhookBass, BillhookBassModel<BillhookBass>> {
    public BillhookBassRenderer(EntityRendererProvider.Context context) {
        super(context, new BillhookBassModel(context.bakeLayer(NMLModelLayers.BASS_LAYER)), 0.4f);
    }

    protected void setupRotations(BillhookBass billhookBass, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)billhookBass, poseStack, bob, yBodyRot, partialTick, scale);
        float f = 1.0f;
        float f1 = 1.0f;
        if (!billhookBass.isInWater()) {
            f = 1.3f;
            f1 = 1.7f;
        }
        float f2 = f * 4.3f * Mth.sin((float)(f1 * 0.6f * bob));
        poseStack.mulPose(Axis.YP.rotationDegrees(f2));
        poseStack.translate(0.0f, 0.0f, -0.4f);
        if (!billhookBass.isInWater()) {
            poseStack.translate(0.2f, 0.1f, 0.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(BillhookBass billhookBass) {
        BillhookBassVariant variant = null;
        for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)billhookBass, (LevelAccessor)billhookBass.level())) {
            BillhookBassVariant billhookBassVariant;
            Object object = animalVariantHolder.value();
            if (!(object instanceof BillhookBassVariant)) continue;
            variant = billhookBassVariant = (BillhookBassVariant)((Object)object);
            break;
        }
        if (variant == null) {
            variant = (BillhookBassVariant)((Object)billhookBass.registryAccess().registryOrThrow(MLRegistries.ANIMAL_VARIANT_KEY).holders().filter(mobVariantReference -> mobVariantReference.value() instanceof BillhookBassVariant).findAny().orElseThrow().value());
        }
        ResourceLocation texture = variant.texture;
        return texture.withPath(path -> "textures/" + path + ".png");
    }
}

