/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.renderer;

import com.farcr.nomansland.client.NMLModelLayers;
import com.farcr.nomansland.client.model.deer.DeerAntlersLayer;
import com.farcr.nomansland.client.model.deer.DeerModel;
import com.farcr.nomansland.client.model.deer.DeerPatternLayer;
import com.farcr.nomansland.common.entity.deer.Deer;
import com.farcr.nomansland.common.entity.deer.DeerVariant;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tazer.mixed_litter.MLRegistries;
import dev.tazer.mixed_litter.VariantUtil;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DeerRenderer
extends MobRenderer<Deer, DeerModel<Deer>> {
    public DeerRenderer(EntityRendererProvider.Context context) {
        super(context, new DeerModel(context.bakeLayer(NMLModelLayers.DEER_LAYER)), 0.4f);
        this.addLayer(new DeerAntlersLayer((RenderLayerParent<Deer, DeerModel<Deer>>)this));
        this.addLayer(new DeerPatternLayer((RenderLayerParent<Deer, DeerModel<Deer>>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(Deer deer) {
        DeerVariant variant = null;
        for (Holder animalVariantHolder : VariantUtil.getVariants((Mob)deer, (LevelAccessor)deer.level())) {
            DeerVariant deerVariant;
            Object object = animalVariantHolder.value();
            if (!(object instanceof DeerVariant)) continue;
            variant = deerVariant = (DeerVariant)((Object)object);
            break;
        }
        if (variant == null) {
            variant = (DeerVariant)((Object)deer.registryAccess().registryOrThrow(MLRegistries.ANIMAL_VARIANT_KEY).holders().filter(mobVariantReference -> mobVariantReference.value() instanceof DeerVariant).findAny().orElseThrow().value());
        }
        ResourceLocation texture = deer.isBaby() ? variant.babyTexture : variant.texture;
        return texture.withPath(path -> "textures/" + path + ".png");
    }

    protected void scale(Deer deer, PoseStack poseStack, float partialTickTime) {
        poseStack.scale(1.1f, 1.1f, 1.1f);
        super.scale((LivingEntity)deer, poseStack, partialTickTime);
    }
}

