/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShelfMushroomBlock
extends BaseCoralWallFanBlock
implements BonemealableBlock {
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)4.0, (double)6.0, (double)9.0, (double)12.0, (double)9.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)4.0, (double)6.0, (double)0.0, (double)12.0, (double)9.0, (double)7.0), (Object)Direction.WEST, (Object)Block.box((double)9.0, (double)6.0, (double)4.0, (double)16.0, (double)9.0, (double)12.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)6.0, (double)4.0, (double)7.0, (double)9.0, (double)12.0)));

    public ShelfMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isAcceptableNeighbour(BlockGetter blockReader, BlockPos neighborPos) {
        BlockState blockstate = blockReader.getBlockState(neighborPos);
        return blockstate.is(BlockTags.LOGS) || blockstate.is(NMLTags.MUSHROOM_BLOCKS);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        if (blockstate.hasProperty((Property)SlabBlock.TYPE) && blockstate.getValue((Property)SlabBlock.TYPE) != SlabType.DOUBLE) {
            return false;
        }
        return blockstate.is(BlockTags.LOGS) || blockstate.is(NMLTags.MUSHROOM_BLOCKS);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        Direction facing = (Direction)blockState.getValue((Property)BaseCoralWallFanBlock.FACING);
        BlockPos sidePos = serverLevel.random.nextBoolean() && serverLevel.isEmptyBlock(blockPos.relative(facing.getClockWise())) ? blockPos.relative(facing.getClockWise()) : (serverLevel.isEmptyBlock(blockPos.relative(facing.getCounterClockWise())) ? blockPos.relative(facing.getCounterClockWise()) : (serverLevel.isEmptyBlock(blockPos.relative(facing.getClockWise())) ? blockPos.relative(facing.getClockWise()) : null));
        BlockState newState = (BlockState)((SlabBlock)NMLBlocks.SHELF_MUSHROOM_BLOCK.get()).defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)(serverLevel.random.nextBoolean() ? SlabType.BOTTOM : SlabType.TOP));
        serverLevel.setBlockAndUpdate(blockPos, newState);
        if (sidePos != null) {
            serverLevel.setBlockAndUpdate(sidePos, newState);
            if (serverLevel.isEmptyBlock(sidePos.relative(facing.getOpposite()))) {
                serverLevel.setBlockAndUpdate(sidePos.relative(facing.getOpposite()), newState);
            }
        }
    }
}

