/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.common.blockentity.WardingEffigyBlockEntity;
import com.farcr.nomansland.common.saved_data.WardedSpacesData;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WardingEffigyBlock
extends BaseEntityBlock {
    public static final IntegerProperty EFFIGIES = IntegerProperty.create((String)"effigies", (int)1, (int)4);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final VoxelShape Z_ONE_AABB = Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)10.0, (double)10.5);
    protected static final VoxelShape Z_TWO_AABB = Block.box((double)1.5, (double)0.0, (double)5.5, (double)14.5, (double)10.0, (double)10.5);
    protected static final VoxelShape Z_FULL_AABB = Block.box((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)10.0, (double)14.5);
    protected static final VoxelShape X_ONE_AABB = Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)10.0, (double)10.5);
    protected static final VoxelShape X_TWO_AABB = Block.box((double)5.5, (double)0.0, (double)1.5, (double)10.5, (double)10.0, (double)14.5);
    protected static final VoxelShape X_FULL_AABB = Block.box((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)10.0, (double)14.5);

    public WardingEffigyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EFFIGIES, (Comparable)Integer.valueOf(1)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return WardingEffigyBlock.simpleCodec(WardingEffigyBlock::new);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        BlockState state = blockEntity != null ? blockEntity.getBlockState() : context.getLevel().getBlockState(context.getClickedPos());
        if (state.is((Block)this)) {
            return (BlockState)state.setValue((Property)EFFIGIES, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.getValue((Property)EFFIGIES) + 1)));
        }
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public static int getRange(BlockState state) {
        int i = (Integer)state.getValue((Property)EFFIGIES);
        return 24 + 20 * (i - 1) - 2 * (i - 1) * (i - 2);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return !state.getCollisionShape(level, pos).getFaceShape(Direction.UP).isEmpty() || state.isFaceSturdy(level, pos, Direction.UP);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return this.mayPlaceOn(level.getBlockState(blockpos), (BlockGetter)level, blockpos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)EFFIGIES)) {
            default -> {
                switch ((Direction)state.getValue(FACING)) {
                    default: {
                        yield Z_ONE_AABB;
                    }
                    case EAST: 
                    case WEST: 
                }
                yield X_ONE_AABB;
            }
            case 2 -> {
                switch ((Direction)state.getValue(FACING)) {
                    default: {
                        yield Z_TWO_AABB;
                    }
                    case EAST: 
                    case WEST: 
                }
                yield X_TWO_AABB;
            }
            case 3, 4 -> {
                switch ((Direction)state.getValue(FACING)) {
                    default: {
                        yield Z_FULL_AABB;
                    }
                    case EAST: 
                    case WEST: 
                }
                yield X_FULL_AABB;
            }
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, EFFIGIES});
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)EFFIGIES) < 4 || super.canBeReplaced(state, useContext);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WardedSpacesData wardedSpacesData = (WardedSpacesData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new WardedSpacesData(new ArrayList<BlockPos>(), new ArrayList<Integer>()), WardedSpacesData::load), "warded_spaces");
            wardedSpacesData.removeEffigy(pos);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WardedSpacesData wardedSpacesData = (WardedSpacesData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new WardedSpacesData(new ArrayList<BlockPos>(), new ArrayList<Integer>()), WardedSpacesData::load), "warded_spaces");
            wardedSpacesData.addEffigy(pos, WardingEffigyBlock.getRange(state));
        }
        super.onPlace(state, level, pos, oldState, movedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WardingEffigyBlockEntity(pos, state);
    }
}

