/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.cauldrons;

import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.integration.Mods;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.NMLSounds;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.event.EventHooks;

public class MilkCauldron
extends FourLayeredCauldronBlock {
    public MilkCauldron() {
        super(NMLParticleTypes.MILK_DROPLET);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        MobEffectInstance selectedEffect;
        Iterator itr = player.getActiveEffects().iterator();
        ArrayList<Holder> compatibleEffects = new ArrayList<Holder>();
        while (itr.hasNext()) {
            selectedEffect = (MobEffectInstance)itr.next();
            if (!selectedEffect.getCures().contains(EffectCures.MILK)) continue;
            compatibleEffects.add(selectedEffect.getEffect());
        }
        if (!compatibleEffects.isEmpty() && (selectedEffect = player.getEffect((Holder)compatibleEffects.get(level.random.nextInt(compatibleEffects.size())))) != null && !EventHooks.onEffectRemoved((LivingEntity)player, (MobEffectInstance)selectedEffect, (EffectCure)EffectCures.MILK)) {
            player.removeEffect(selectedEffect.getEffect());
        }
        level.playSound(player, pos, (SoundEvent)NMLSounds.PLAYER_DRINK_MILK.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        MilkCauldron.lowerFillLevel(state, level, pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockState newState;
        boolean interacted = false;
        if (player.isHolding(Items.BUCKET) && this.isFull(state)) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.MILK_BUCKET.getDefaultInstance()));
            interacted = true;
            newState = Blocks.CAULDRON.defaultBlockState();
            level.setBlockAndUpdate(pos, newState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
            level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS);
        }
        if (player.isHolding(Items.MILK_BUCKET) && !this.isFull(state)) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.BUCKET.getDefaultInstance()));
            interacted = true;
            newState = (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(3));
            level.setBlockAndUpdate(pos, newState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS);
        }
        if (Mods.FARMERSDELIGHT.isLoaded()) {
            if (stack.is(Items.GLASS_BOTTLE)) {
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Mods.FARMERSDELIGHT.getItem("milk_bottle").getDefaultInstance()));
                interacted = true;
                MilkCauldron.lowerFillLevel(state, level, pos);
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
            }
            if (stack.is(Mods.FARMERSDELIGHT.getItem("milk_bottle")) && !this.isFull(state)) {
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.GLASS_BOTTLE.getDefaultInstance()));
                interacted = true;
                this.raiseFillLevel(state, level, pos);
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
            }
        }
        if (interacted) {
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (!level.isClientSide && entity.isOnFire() && this.isEntityInsideContent(state, pos, entity)) {
            entity.clearFire();
            level.playSound(entity, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

