/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.blockentity;

import com.farcr.nomansland.common.entity.bombs.ThrowableBombEntity;
import com.farcr.nomansland.common.item.ThrowableBombItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BombDispenseBehavior
extends DefaultDispenseItemBehavior {
    private final ThrowableBombItem throwableBombItem;

    public BombDispenseBehavior(Item bomb) {
        ThrowableBombItem throwableBombItem;
        if (!(bomb instanceof ThrowableBombItem)) {
            String name = String.valueOf(bomb);
            throw new IllegalArgumentException(name + " not instance of " + ThrowableBombItem.class.getSimpleName());
        }
        this.throwableBombItem = throwableBombItem = (ThrowableBombItem)bomb;
    }

    public ItemStack execute(BlockSource source, ItemStack item) {
        ServerLevel level = source.level();
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        Position position = DispenserBlock.getDispensePosition((BlockSource)source, (double)0.7, (Vec3)new Vec3(0.0, 0.1, 0.0));
        ThrowableBombEntity bomb = this.throwableBombItem.createBomb((Level)level, BlockPos.containing((Position)position));
        bomb.shoot(direction.getStepX(), direction.getStepY(), direction.getStepZ(), 0.5f, 6.0f);
        level.addFreshEntity((Entity)bomb);
        item.shrink(1);
        return item;
    }

    protected void playSound(BlockSource source) {
        source.level().levelEvent(1002, source.pos(), 0);
    }
}

