/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.blockentity;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.block.cauldrons.HoneyCauldron;
import com.farcr.nomansland.common.block.tap.TapBlock;
import com.farcr.nomansland.common.registry.NMLBlockEntities;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class TapBlockEntity
extends BlockEntity {
    public int timeEmptying = 0;

    public TapBlockEntity(BlockPos pos, BlockState state) {
        super(NMLBlockEntities.TAP.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TapBlockEntity tap) {
        Block block;
        BlockPos cauldronPos = TapBlock.getCauldronPos(level, pos);
        boolean cauldronFound = cauldronPos != null;
        cauldronPos = cauldronFound ? cauldronPos : pos.below();
        BlockState cauldronState = level.getBlockState(cauldronPos);
        BlockState stateBehind = TapBlock.getBlockStateBehind(level, pos, state);
        BlockPos posBehind = pos.relative(((Direction)state.getValue((Property)TapBlock.FACING)).getOpposite());
        Block cauldronBlock = cauldronState.getBlock();
        if (stateBehind.hasProperty((Property)StairBlock.WATERLOGGED) && ((Boolean)stateBehind.getValue((Property)StairBlock.WATERLOGGED)).booleanValue() || stateBehind.is(Blocks.WATER_CAULDRON)) {
            TapBlock.spawnDrippingParticles(level, pos, state, ParticleTypes.FALLING_WATER);
            if (cauldronFound && !((AbstractCauldronBlock)cauldronBlock).isFull(cauldronState) && (cauldronBlock instanceof CauldronBlock || cauldronState.is(Blocks.WATER_CAULDRON))) {
                ++tap.timeEmptying;
                if (tap.timeEmptying > (Integer)NMLConfig.TICKS_TO_FILL_CAULDRON.get()) {
                    if (cauldronState.hasProperty((Property)LayeredCauldronBlock.LEVEL)) {
                        level.setBlockAndUpdate(cauldronPos, (BlockState)cauldronState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)cauldronState.getValue((Property)LayeredCauldronBlock.LEVEL) + 1)));
                    } else {
                        level.setBlockAndUpdate(cauldronPos, Blocks.WATER_CAULDRON.defaultBlockState());
                    }
                    if (cauldronState.hasProperty((Property)StairBlock.WATERLOGGED) && !((Boolean)cauldronState.getValue((Property)StairBlock.WATERLOGGED)).booleanValue()) {
                        level.setBlockAndUpdate(cauldronPos, (BlockState)cauldronState.setValue((Property)StairBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                    }
                    tap.timeEmptying = 0;
                }
            }
        }
        if (!cauldronFound) {
            return;
        }
        if (stateBehind.hasProperty((Property)BeehiveBlock.HONEY_LEVEL) && (Integer)stateBehind.getValue((Property)BeehiveBlock.HONEY_LEVEL) == 5 && !((AbstractCauldronBlock)cauldronBlock).isFull(cauldronState) && (cauldronBlock instanceof CauldronBlock || cauldronState.is(NMLBlocks.HONEY_CAULDRON.block()))) {
            ++tap.timeEmptying;
            if (tap.timeEmptying < (Integer)NMLConfig.TICKS_TO_FILL_CAULDRON.get()) {
                TapBlock.spawnDrippingParticles(level, pos, state, ParticleTypes.FALLING_HONEY);
            } else {
                tap.timeEmptying = 0;
                if (cauldronState.hasProperty((Property)FourLayeredCauldronBlock.LEVEL)) {
                    level.setBlockAndUpdate(cauldronPos, (BlockState)cauldronState.setValue((Property)FourLayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)cauldronState.getValue((Property)FourLayeredCauldronBlock.LEVEL) + 1)));
                } else {
                    level.setBlockAndUpdate(cauldronPos, ((HoneyCauldron)((Object)NMLBlocks.HONEY_CAULDRON.get())).defaultBlockState());
                }
                BlockPos beehivePos = pos.relative(((Direction)state.getValue((Property)TapBlock.FACING)).getOpposite());
                level.setBlockAndUpdate(beehivePos, (BlockState)stateBehind.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(0)));
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, beehivePos, GameEvent.Context.of((BlockState)stateBehind));
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, cauldronPos, GameEvent.Context.of((BlockState)cauldronState));
            }
        }
        if ((stateBehind.is(Blocks.LAVA_CAULDRON) || stateBehind.is(Blocks.WATER_CAULDRON)) && !((AbstractCauldronBlock)cauldronBlock).isFull(cauldronState) && (cauldronBlock instanceof CauldronBlock || cauldronState.is(stateBehind.getBlock()))) {
            ++tap.timeEmptying;
            if (tap.timeEmptying < (Integer)NMLConfig.TICKS_TO_FILL_CAULDRON.get()) {
                TapBlock.spawnDrippingParticles(level, pos, state, stateBehind.is(Blocks.LAVA_CAULDRON) ? ParticleTypes.FALLING_LAVA : ParticleTypes.FALLING_WATER);
            } else {
                tap.timeEmptying = 0;
                if (stateBehind.is(Blocks.LAVA_CAULDRON)) {
                    level.setBlockAndUpdate(posBehind, Blocks.CAULDRON.defaultBlockState());
                    level.setBlockAndUpdate(cauldronPos, Blocks.LAVA_CAULDRON.defaultBlockState());
                } else {
                    LayeredCauldronBlock.lowerFillLevel((BlockState)stateBehind, (Level)level, (BlockPos)posBehind);
                    level.setBlockAndUpdate(cauldronPos, (BlockState)stateBehind.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)cauldronState.getValue((Property)LayeredCauldronBlock.LEVEL) + 1)));
                }
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, cauldronPos, GameEvent.Context.of((BlockState)cauldronState));
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, posBehind, GameEvent.Context.of((BlockState)stateBehind));
            }
        }
        if ((block = stateBehind.getBlock()) instanceof FourLayeredCauldronBlock) {
            FourLayeredCauldronBlock fourLayeredCauldronBlock = (FourLayeredCauldronBlock)block;
            if (!((AbstractCauldronBlock)cauldronBlock).isFull(cauldronState)) {
                ++tap.timeEmptying;
                if (tap.timeEmptying < (Integer)NMLConfig.TICKS_TO_FILL_CAULDRON.get()) {
                    TapBlock.spawnDrippingParticles(level, pos, state, fourLayeredCauldronBlock.particleType.get());
                } else {
                    tap.timeEmptying = 0;
                    FourLayeredCauldronBlock.lowerFillLevel(stateBehind, level, posBehind);
                    if (cauldronState.hasProperty((Property)FourLayeredCauldronBlock.LEVEL)) {
                        level.setBlockAndUpdate(cauldronPos, (BlockState)stateBehind.setValue((Property)FourLayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)cauldronState.getValue((Property)FourLayeredCauldronBlock.LEVEL) + 1)));
                    } else {
                        level.setBlockAndUpdate(cauldronPos, stateBehind.getBlock().defaultBlockState());
                    }
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, cauldronPos, GameEvent.Context.of((BlockState)cauldronState));
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, posBehind, GameEvent.Context.of((BlockState)stateBehind));
                }
            }
        }
    }
}

