/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.blockentity.anchor;

import com.farcr.nomansland.common.blockentity.anchor.MonsterAnchorBlockEntity;
import com.farcr.nomansland.common.mixinduck.LivingEntityDuck;
import com.farcr.nomansland.common.registry.NMLCriteriaTriggers;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.NMLTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AnchorListener
implements GameEventListener {
    private final BlockState state;
    private final PositionSource positionSource;

    public AnchorListener(BlockState state, PositionSource positionSource) {
        this.state = state;
        this.positionSource = positionSource;
    }

    public static List<Vec3> surroundBoundingBox(AABB boundingBox, double step) {
        double z;
        double z2;
        Vec3 point;
        double y;
        double x;
        double minX = boundingBox.minX;
        double minY = boundingBox.minY;
        double minZ = boundingBox.minZ;
        double maxX = boundingBox.maxX;
        double maxY = boundingBox.maxY;
        double maxZ = boundingBox.maxZ;
        ArrayList<Vec3> pointList = new ArrayList<Vec3>();
        for (x = minX; x <= maxX; x += step) {
            for (y = minY; y <= maxY; y += step) {
                point = new Vec3(x, y, minZ);
                pointList.add(point);
            }
        }
        for (x = minX; x <= maxX; x += step) {
            for (y = minY; y <= maxY; y += step) {
                point = new Vec3(x, y, maxZ);
                pointList.add(point);
            }
        }
        for (z2 = minZ; z2 <= maxZ; z2 += step) {
            for (y = minY; y <= maxY; y += step) {
                point = new Vec3(minX, y, z2);
                pointList.add(point);
            }
        }
        for (z2 = minZ; z2 <= maxZ; z2 += step) {
            for (y = minY; y <= maxY; y += step) {
                point = new Vec3(maxX, y, z2);
                pointList.add(point);
            }
        }
        for (x = minX; x <= maxX; x += step) {
            for (z = minZ; z <= maxZ; z += step) {
                point = new Vec3(x, maxY, z);
                pointList.add(point);
            }
        }
        for (x = minX; x <= maxX; x += step) {
            for (z = minZ; z <= maxZ; z += step) {
                point = new Vec3(x, minY, z);
                pointList.add(point);
            }
        }
        return pointList;
    }

    public PositionSource getListenerSource() {
        return this.positionSource;
    }

    public int getListenerRadius() {
        return 16;
    }

    public boolean handleGameEvent(ServerLevel level, Holder<GameEvent> gameEvent, GameEvent.Context context, Vec3 pos) {
        Entity entity = context.sourceEntity();
        if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            if (GameEvent.ENTITY_DIE.is(gameEvent)) {
                Vec3 sourcePos = (Vec3)this.positionSource.getPosition((Level)level).orElseThrow();
                MonsterAnchorBlockEntity monsterAnchorBlockEntity = (MonsterAnchorBlockEntity)Optional.ofNullable(level.getBlockEntity(BlockPos.containing((Position)sourcePos))).orElseThrow();
                if (pos.distanceToSqr(sourcePos) > (double)Mth.square((int)monsterAnchorBlockEntity.range)) {
                    return false;
                }
                if (GameEvent.ENTITY_DIE.is(gameEvent)) {
                    if (!monster.getType().getTags().toList().contains(NMLTags.ANCHOR_BLACKLIST) && !monster.wasExperienceConsumed()) {
                        monsterAnchorBlockEntity.entityQueue.put((LivingEntity)monster, monster.getPosition(0.0f));
                        monster.skipDropExperience();
                        ((LivingEntityDuck)monster).nml$skipDroppingDeathLoot();
                        AABB boundingBox = monster.getBoundingBox();
                        AnchorListener.surroundBoundingBox(boundingBox, 0.2).forEach(point -> level.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_EMBERS.get(), point.x, point.y, point.z, 1, 0.0, 0.0, 0.0, 0.0));
                        AnchorListener.tryAwardAdvancement((Level)level, monster);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public GameEventListener.DeliveryMode getDeliveryMode() {
        return GameEventListener.DeliveryMode.BY_DISTANCE;
    }

    private static void tryAwardAdvancement(Level level, Monster monster) {
        LivingEntity livingEntity = monster.getLastHurtByMob();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)livingEntity;
            DamageSource damagesource = monster.getLastDamageSource() == null ? level.damageSources().playerAttack((Player)serverplayer) : monster.getLastDamageSource();
            ((KilledTrigger)NMLCriteriaTriggers.KILL_MOB_NEAR_MONSTER_ANCHOR.get()).trigger(serverplayer, (Entity)monster, damagesource);
        }
    }
}

