/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.blockentity.anchor;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.block.MonsterAnchorBlock;
import com.farcr.nomansland.common.blockentity.anchor.AnchorListener;
import com.farcr.nomansland.common.registry.NMLBlockEntities;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.NMLSounds;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class MonsterAnchorBlockEntity
extends BlockEntity
implements GameEventListener.Provider<AnchorListener> {
    public final LinkedHashMap<LivingEntity, Vec3> entityQueue;
    private final AnchorListener anchorListener;
    public int timeResurrecting;
    public int timeIdle;
    public int range;

    public MonsterAnchorBlockEntity(BlockPos pos, BlockState state) {
        super(NMLBlockEntities.MONSTER_ANCHOR.get(), pos, state);
        this.anchorListener = new AnchorListener(state, (PositionSource)new BlockPositionSource(pos));
        this.entityQueue = new LinkedHashMap();
        this.timeResurrecting = 0;
        this.timeIdle = 0;
        this.range = 7;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MonsterAnchorBlockEntity monsterAnchor) {
        ServerLevel serverLevel = (ServerLevel)level;
        LinkedHashMap<LivingEntity, Vec3> entityQueue = monsterAnchor.entityQueue;
        ArrayList<LivingEntity> deadEntities = new ArrayList<LivingEntity>(entityQueue.keySet());
        boolean empty = entityQueue.isEmpty();
        RandomSource random = level.random;
        int timeBetweenResurrections = (Integer)NMLConfig.TICKS_BETWEEN_RESURRECTIONS.get();
        if (empty) {
            monsterAnchor.timeResurrecting = 0;
            ++monsterAnchor.timeIdle;
            if (((Boolean)state.getValue((Property)MonsterAnchorBlock.ACTIVE)).booleanValue()) {
                level.playSound(null, pos, (SoundEvent)NMLSounds.ANCHOR_DEACTIVATES.get(), SoundSource.BLOCKS, 1.0f, 0.75f);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MonsterAnchorBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
                level.gameEvent((Holder)GameEvent.BLOCK_DEACTIVATE, pos, GameEvent.Context.of((BlockState)state));
            } else if (monsterAnchor.timeIdle % 5 == 0) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + (double)random.nextInt(0, 3) * 0.01 - (double)random.nextInt(0, 3) * 0.01, (double)pos.getY() + 0.2, (double)pos.getZ() + 0.5 + (double)random.nextInt(0, 3) * 0.01 - (double)random.nextInt(0, 3) * 0.01, 3, 0.0, 0.0, 0.0, 0.0);
                monsterAnchor.timeIdle = 0;
            }
            return;
        }
        monsterAnchor.timeIdle = 0;
        ++monsterAnchor.timeResurrecting;
        serverLevel.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_FLAME.get(), (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), monsterAnchor.timeResurrecting, 0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < deadEntities.size(); ++i) {
            LivingEntity deadEntity = (LivingEntity)deadEntities.get(i);
            Vec3 spawningPosition = entityQueue.get(deadEntity);
            if (level.random.nextFloat() <= 0.1f) {
                serverLevel.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_FLAME.get(), spawningPosition.x + (double)random.nextFloat() - (double)random.nextFloat(), spawningPosition.y + (double)random.nextFloat() - (double)random.nextFloat(), spawningPosition.z + (double)random.nextFloat() - (double)random.nextFloat(), 3, 0.0, 0.0, 0.0, 0.0);
            }
            if (monsterAnchor.timeResurrecting % timeBetweenResurrections == 0 && i != 0) {
                for (double y = 0.0; y <= 4.0; y += 1.0) {
                    if (!level.getBlockState(BlockPos.containing((Position)spawningPosition.relative(Direction.DOWN, y))).isSolid()) continue;
                    LivingEntity tempEntity = (LivingEntity)deadEntity.getType().create(level);
                    if (tempEntity != null) {
                        tempEntity.moveTo(spawningPosition);
                    }
                    if (tempEntity instanceof Zombie) {
                        Zombie zombie = (Zombie)tempEntity;
                        zombie.setBaby(deadEntity.isBaby());
                    }
                    double finalY = y - 1.1;
                    AnchorListener.surroundBoundingBox(tempEntity.getBoundingBox(), 0.2).forEach(point -> serverLevel.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_EMBERS.get(), point.x, spawningPosition.y - finalY, point.z, 1, 0.0, 0.0, 0.0, 0.0));
                    tempEntity.remove(Entity.RemovalReason.DISCARDED);
                    break;
                }
            }
            if (i != 0) continue;
            if (monsterAnchor.timeResurrecting <= timeBetweenResurrections - 78) {
                if (!((Boolean)state.getValue((Property)MonsterAnchorBlock.ACTIVE)).booleanValue()) {
                    level.playSound(null, pos, (SoundEvent)NMLSounds.ANCHOR_ACTIVATES.get(), SoundSource.BLOCKS, 1.0f, 0.25f);
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MonsterAnchorBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
                    level.gameEvent((Holder)GameEvent.BLOCK_ACTIVATE, pos, GameEvent.Context.of((BlockState)state));
                }
                level.playSound(null, pos, (SoundEvent)NMLSounds.MONSTER_RESURRECTION.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
            }
            if (monsterAnchor.timeResurrecting != timeBetweenResurrections) continue;
            monsterAnchor.timeResurrecting = 0;
            LivingEntity resurrectedEntity = (LivingEntity)deadEntity.getType().create(level);
            if (resurrectedEntity == null) continue;
            if (resurrectedEntity instanceof Zombie) {
                EquipmentSlot[] zombie = (EquipmentSlot[])resurrectedEntity;
                zombie.setBaby(deadEntity.isBaby());
            }
            resurrectedEntity.moveTo(spawningPosition.x, spawningPosition.y, spawningPosition.z);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack oldItem = deadEntity.getItemBySlot(slot);
                resurrectedEntity.setItemSlot(slot, oldItem);
            }
            if (resurrectedEntity instanceof Mob) {
                Mob deadMob;
                Mob resurrectedMob = (Mob)resurrectedEntity;
                if (deadEntity instanceof Mob && (deadMob = (Mob)deadEntity).isPersistenceRequired()) {
                    resurrectedMob.setPersistenceRequired();
                }
            }
            level.addFreshEntity((Entity)resurrectedEntity);
            serverLevel.gameEvent((Entity)resurrectedEntity, (Holder)GameEvent.ENTITY_PLACE, spawningPosition);
            serverLevel.broadcastEntityEvent((Entity)resurrectedEntity, (byte)20);
            entityQueue.remove(deadEntity);
            for (double y = 0.0; y <= 4.0; y += 1.0) {
                if (!level.getBlockState(BlockPos.containing((Position)spawningPosition.relative(Direction.DOWN, y))).isSolid()) continue;
                double finalY = y - 1.1;
                AnchorListener.surroundBoundingBox(resurrectedEntity.getBoundingBox(), 0.4).forEach(point -> serverLevel.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_FLAME.get(), point.x, spawningPosition.y - finalY, point.z, 1, 0.0, 0.0, 0.0, 0.1));
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("TimeIdle", this.timeIdle);
        tag.putInt("TimeResurrecting", this.timeResurrecting);
        tag.putInt("Range", this.range);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.timeIdle = tag.getInt("TimeIdle");
        this.timeResurrecting = tag.getInt("TimeResurrecting");
        this.range = Math.min(tag.getInt("Range"), 16);
        super.loadAdditional(tag, registries);
    }

    public AnchorListener getListener() {
        return this.anchorListener;
    }
}

