/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.definitions;

import com.farcr.nomansland.common.definitions.Definition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class ItemLikeDefinition<R extends ItemLike, T extends R>
extends Definition<R, T>
implements ItemLike {
    protected ItemLikeDefinition(ResourceKey<R> key, boolean customLang) {
        super(key, customLang);
    }

    @NotNull
    public Item asItem() {
        Item item = ((ItemLike)this.get()).asItem();
        if (item == Items.AIR) {
            throw new IllegalArgumentException("No registered item for " + this.getRegisteredName());
        }
        return item;
    }

    public Item item() {
        return this.asItem();
    }

    public Ingredient ingredient() {
        return this.ingredient(1);
    }

    public Ingredient ingredient(int count) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)this.item(), count)});
    }

    public ItemStack stack() {
        return this.stack(1);
    }

    public ItemStack stack(int count) {
        return new ItemStack((ItemLike)this.item(), count);
    }

    public boolean is(ItemLike itemLike) {
        return ((ItemLike)this.get()).equals((Object)itemLike);
    }
}

