/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity;

import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class Moose
extends Animal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(Moose.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)2400, (int)2400);
    private static final EntityDataAccessor<Integer> DATA_PACIFICATION_STAGE = SynchedEntityData.defineId(Moose.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private UUID persistentAngerTarget;

    public Moose(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ARMOR_TOUGHNESS, (double)0.1f).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_REMAINING_ANGER_TIME, (Object)0);
        builder.define(DATA_PACIFICATION_STAGE, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addPersistentAngerSaveData(compound);
        compound.putInt("PacificationStage", this.getPacificationStage());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readPersistentAngerSaveData(this.level(), compound);
        if (compound.contains("PacificationStage")) {
            this.setPacificationStage(compound.getInt("PacificationStage"));
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void tick() {
        super.tick();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Moose)this).isAngryAt(arg_0)));
        this.goalSelector.addGoal(3, (Goal)new MooseChargeAttackGoal(this, (PathfinderMob)this, 1.0, 1.5, 16, 4));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, 1.15));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of(NMLTags.MOOSE_FOOD), false));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        Moose baby = (Moose)NMLEntities.MOOSE.get().create((Level)pLevel);
        if (baby != null && this.isPacified() && ((Moose)pOtherParent).isPacified()) {
            baby.setPacificationStage(5);
        }
        return baby;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (!this.level().isClientSide || this.isBaby() && this.isFood(itemstack)) {
            if (itemstack.is(Items.GOLDEN_CARROT) && this.getPacificationStage() < 5) {
                int pacificationStage = this.getPacificationStage();
                itemstack.consume(1, (LivingEntity)player);
                if (pacificationStage < 4) {
                    this.setPacificationStage(pacificationStage + 1);
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                } else if (this.random.nextInt(3) == 0) {
                    this.setPacificationStage(5);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.setPersistentAngerTarget(null);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
                return InteractionResult.SUCCESS;
            }
            return super.mobInteract(player, hand);
        }
        boolean flag = itemstack.is(Items.GOLDEN_CARROT) && this.getPacificationStage() < 5;
        return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    protected void spawnTamingParticles(boolean tamed) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!tamed) {
            particleoptions = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleoptions, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 7) {
            this.spawnTamingParticles(true);
        } else if (id == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public int getPacificationStage() {
        return (Integer)this.entityData.get(DATA_PACIFICATION_STAGE);
    }

    public void setPacificationStage(int stage) {
        this.entityData.set(DATA_PACIFICATION_STAGE, (Object)stage);
    }

    public boolean isPacified() {
        return this.getPacificationStage() == 5;
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(NMLTags.MOOSE_FOOD);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.HOGLIN_AMBIENT;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.RAVAGER_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.DOLPHIN_DEATH;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.75f : 1.0f;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public LivingEntity getTarget() {
        if (this.isPacified()) {
            return null;
        }
        return super.getTarget();
    }

    public class MooseChargeAttackGoal
    extends Goal {
        protected final PathfinderMob mob;
        private final double speedModifierFlee;
        private final double speedModifierCharge;
        private final int fleeDistance;
        private final int extraChargeDistance;
        private Path path;
        private Vec3 pathNormalized;
        private long lastCanUseCheck;
        private ChargeState chargeState;

        public MooseChargeAttackGoal(Moose this$0, PathfinderMob mob, double speedModifierFlee, double speedModifierCharge, int fleeDistance, int extraChargeDistance) {
            this.mob = mob;
            this.speedModifierFlee = speedModifierFlee;
            this.speedModifierCharge = speedModifierCharge;
            this.fleeDistance = fleeDistance;
            this.extraChargeDistance = extraChargeDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            long i = this.mob.level().getGameTime();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            Vec3 vec3 = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)this.fleeDistance, (int)7, (Vec3)livingentity.getPosition(0.0f));
            if (vec3 == null) {
                return false;
            }
            this.path = this.mob.getNavigation().createPath(vec3.x, vec3.y, vec3.z, 0);
            return this.path != null || this.mob.isWithinMeleeAttackRange(livingentity);
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (this.mob.getPosition(0.0f).subtract(livingentity.getPosition(0.0f)).horizontalDistance() > (double)((float)this.fleeDistance * 0.75f) && this.chargeState == ChargeState.FLEE) {
                this.chargeState = ChargeState.CHARGE;
                this.mob.getLookControl().setLookAt((Entity)livingentity, 360.0f, 360.0f);
                Vec3 pathNormalized = livingentity.getPosition(0.0f).subtract(this.mob.getPosition(0.0f)).normalize();
                Vec3 newLocation = livingentity.getPosition(0.0f).add(pathNormalized.scale((double)this.extraChargeDistance));
                this.path = this.mob.getNavigation().createPath(newLocation.x, newLocation.y, newLocation.z, 0);
                this.mob.getNavigation().moveTo(this.path, this.speedModifierCharge);
            }
            return true;
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.path, this.speedModifierFlee);
            this.mob.setAggressive(true);
            this.chargeState = ChargeState.FLEE;
        }

        public void stop() {
            LivingEntity livingentity = this.mob.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
                this.mob.setTarget((LivingEntity)null);
            }
            this.mob.setAggressive(false);
            this.mob.getNavigation().stop();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity != null) {
                if (this.chargeState == ChargeState.CHARGE) {
                    this.mob.getLookControl().setLookAt((Entity)livingentity, 360.0f, 360.0f);
                    this.checkAndPerformAttack(livingentity);
                    if (this.mob.getNavigation().isDone()) {
                        this.chargeState = ChargeState.FLEE;
                    }
                } else if (this.chargeState == ChargeState.FLEE && this.mob.getNavigation().isDone() && this.mob.getPosition(0.0f).subtract(livingentity.getPosition(0.0f)).horizontalDistance() <= (double)((float)this.fleeDistance * 0.75f)) {
                    Vec3 vec3 = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)this.fleeDistance, (int)7, (Vec3)livingentity.getPosition(0.0f));
                    if (vec3 == null) {
                        return;
                    }
                    this.path = this.mob.getNavigation().createPath(vec3.x, vec3.y, vec3.z, 0);
                    this.mob.getNavigation().moveTo(this.path, this.speedModifierFlee);
                }
            }
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target)) {
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget((Entity)target);
                this.chargeState = ChargeState.FLEE;
                boolean i = false;
                Vec3 vec3 = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)this.fleeDistance, (int)7, (Vec3)target.getPosition(0.0f));
                if (vec3 == null) {
                    return;
                }
                this.path = this.mob.getNavigation().createPath(vec3.x, vec3.y, vec3.z, 0);
                this.mob.getNavigation().moveTo(this.path, this.speedModifierFlee);
            }
        }

        protected boolean canPerformAttack(LivingEntity entity) {
            return this.mob.isWithinMeleeAttackRange(entity) && this.mob.getSensing().hasLineOfSight((Entity)entity);
        }

        private static enum ChargeState {
            FLEE,
            CHARGE,
            POSTCHARGE;

        }
    }
}

