/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.bombs;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.block.torches.SconceTorchBlock;
import com.farcr.nomansland.common.block.torches.SconceWallTorchBlock;
import com.farcr.nomansland.common.entity.bombs.ThrowableBombEntity;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ExplosiveEntity
extends ThrowableBombEntity {
    private BlockPos hitPos;

    public ExplosiveEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ExplosiveEntity(LivingEntity livingEntity, Level level) {
        super(NMLEntities.EXPLOSIVE.get(), livingEntity, level);
    }

    public ExplosiveEntity(Level level, double x, double y, double z) {
        super(NMLEntities.EXPLOSIVE.get(), x, y, z, level);
    }

    private void spawnParticles(ParticleOptions particle, int amount) {
        for (int i = 0; i < amount; ++i) {
            double theta = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
            double alpha = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
            double cos = Math.cos(alpha);
            double xVelocity = Math.sin(theta) * cos * ((double)this.random.nextFloat() * 0.3 + 0.7);
            double yVelocity = cos * Math.cos(theta) * ((double)this.random.nextFloat() * 0.3 + 0.7);
            double zVelocity = Math.sin(alpha) * ((double)this.random.nextFloat() * 0.3 + 0.7);
            this.level().addParticle(particle, this.getX(), this.getY(), this.getZ(), xVelocity * 0.6, yVelocity * 0.6, zVelocity * 0.6);
        }
    }

    public void handleEntityEvent(byte b) {
        if (b == 0) {
            this.spawnParticles((ParticleOptions)ParticleTypes.SMOKE, 320);
            for (int i = 0; i < 40; ++i) {
                double theta = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double alpha = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double cos = Math.cos(alpha);
                double xVelocity = Math.sin(theta) * cos * ((double)this.random.nextFloat() * 0.3 + 0.7);
                double yVelocity = cos * Math.cos(theta) * ((double)this.random.nextFloat() * 0.3 + 0.7);
                double zVelocity = Math.sin(alpha) * ((double)this.random.nextFloat() * 0.3 + 0.7);
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, false, this.getX(), this.getY(), this.getZ(), xVelocity * 0.1, yVelocity * 0.1, zVelocity * 0.1);
            }
        } else if (b == 1) {
            this.spawnParticles((ParticleOptions)ParticleTypes.SMOKE, 400);
        } else {
            super.handleEntityEvent(b);
        }
    }

    @Override
    protected void explode() {
        Level level = this.level();
        level.explode((Entity)this, Explosion.getDefaultDamageSource((Level)level, (Entity)this), null, this.getX(), this.getY(0.0625), this.getZ(), ((Double)NMLConfig.EXPLOSIVE_STRENGTH.get()).floatValue(), false, Level.ExplosionInteraction.TNT);
        BlockPos.withinManhattan((BlockPos)this.blockPosition(), (int)6, (int)4, (int)6).forEach(pos -> {
            BlockState state = level.getBlockState(pos);
            if (state.is(BlockTags.CAMPFIRES) && state.hasProperty((Property)CampfireBlock.LIT) && !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)));
            }
            if (state.is(Blocks.TNT)) {
                TntBlock.explode((Level)level, (BlockPos)pos);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            }
            if (state.is((Block)NMLBlocks.EXTINGUISHED_TORCH.get())) {
                level.setBlockAndUpdate(pos, Blocks.TORCH.defaultBlockState());
            } else if (state.is((Block)NMLBlocks.EXTINGUISHED_WALL_TORCH.get())) {
                level.setBlockAndUpdate(pos, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))));
            } else if (state.is((Block)NMLBlocks.EXTINGUISHED_SOUL_TORCH.get())) {
                level.setBlockAndUpdate(pos, Blocks.SOUL_TORCH.defaultBlockState());
            } else if (state.is((Block)NMLBlocks.EXTINGUISHED_SOUL_WALL_TORCH.get())) {
                level.setBlockAndUpdate(pos, (BlockState)Blocks.SOUL_WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))));
            } else if (state.is((Block)NMLBlocks.EXTINGUISHED_SCONCE_TORCH.get())) {
                level.setBlockAndUpdate(pos, ((SconceTorchBlock)((Object)((Object)NMLBlocks.SCONCE_TORCH.get()))).defaultBlockState());
            } else if (state.is((Block)NMLBlocks.EXTINGUISHED_SCONCE_WALL_TORCH.get())) {
                level.setBlockAndUpdate(pos, (BlockState)((SconceWallTorchBlock)((Object)((Object)NMLBlocks.SCONCE_WALL_TORCH.get()))).defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))));
            } else if (state.is((Block)NMLBlocks.EXTINGUISHED_SCONCE_SOUL_TORCH.get())) {
                level.setBlockAndUpdate(pos, ((SconceTorchBlock)((Object)((Object)NMLBlocks.SCONCE_SOUL_TORCH.get()))).defaultBlockState());
            } else if (state.is((Block)NMLBlocks.EXTINGUISHED_SCONCE_SOUL_WALL_TORCH.get())) {
                level.setBlockAndUpdate(pos, (BlockState)((SconceWallTorchBlock)((Object)((Object)NMLBlocks.SCONCE_SOUL_WALL_TORCH.get()))).defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)((Direction)state.getValue((Property)WallTorchBlock.FACING))));
            }
        });
        level.broadcastEntityEvent((Entity)this, (byte)(this.isInWater() ? 1 : 0));
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Vec3 pos = this.position();
        Vec3 resultPos = result.getLocation();
        Vec3 dir = pos.vectorTo(resultPos).normalize();
        this.setDeltaMovement(Vec3.ZERO);
        this.setPos(new Vec3(resultPos.x - dir.x * (double)this.getBbWidth() * 0.01, resultPos.y - dir.y * (double)this.getBbHeight() * 0.01, resultPos.z - dir.z * (double)this.getBbWidth() * 0.01));
        this.setNoGravity(true);
        if (!this.shouldFuse()) {
            this.startFuse(100);
        }
        this.hitPos = result.getBlockPos();
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        this.setDeltaMovement(this.getDeltaMovement().scale(-0.1));
        if (!this.shouldFuse()) {
            this.startFuse(100);
        }
    }

    @Override
    public void tick() {
        if (this.hitPos != null && this.level().getBlockState(this.hitPos).getCollisionShape((BlockGetter)this.level(), this.hitPos).isEmpty()) {
            this.hitPos = null;
            this.setNoGravity(false);
        }
        super.tick();
    }

    @Override
    protected ParticleOptions getParticle() {
        return ParticleTypes.SMOKE;
    }
}

