/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.deer;

import com.farcr.nomansland.common.entity.deer.Deer;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;

public class DeerDrinkWaterGoal
extends Goal {
    private final Deer mob;
    @Nullable
    protected Path path;
    private final Level level;
    private int drinkAnimationTick;

    public DeerDrinkWaterGoal(Deer mob) {
        this.mob = mob;
        this.level = mob.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.mob.getHydration() < 0 && this.mob.getRandom().nextInt(80) == 0) {
            Level level = this.mob.level();
            Iterable iterable = BlockPos.betweenClosed((int)Mth.floor((double)(this.mob.getX() - 10.0)), (int)Mth.floor((double)(this.mob.getY() - 10.0)), (int)Mth.floor((double)(this.mob.getZ() - 10.0)), (int)Mth.floor((double)(this.mob.getX() + 10.0)), (int)Mth.floor((double)(this.mob.getY() + 10.0)), (int)Mth.floor((double)(this.mob.getZ() + 10.0)));
            BlockPos blockpos = null;
            for (BlockPos blockpos1 : iterable) {
                if (!level.getBlockState(blockpos1).is(Blocks.WATER)) continue;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!level.getBlockState(blockpos1.relative(direction)).isPathfindable(PathComputationType.LAND) || !this.mob.getRandom().nextBoolean()) continue;
                    blockpos = blockpos1.relative(direction).above();
                    break;
                }
                if (blockpos == null) continue;
                this.path = this.mob.getNavigation().createPath((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), 0);
                break;
            }
        }
        return this.path != null;
    }

    public void start() {
        this.drinkAnimationTick = this.adjustedTickDelay(this.mob.getRandom().nextInt(40, 120));
        this.level.broadcastEntityEvent((Entity)this.mob, (byte)10);
        this.mob.getNavigation().moveTo(this.path, 1.0);
    }

    public boolean canContinueToUse() {
        return this.mob.getHydration() < this.mob.getRandom().nextInt(500, 2000) && this.drinkAnimationTick > 0;
    }

    public void tick() {
        if (!this.mob.isPathFinding()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!this.mob.level().getBlockState(this.mob.blockPosition().below().relative(direction)).is(Blocks.WATER)) continue;
                this.drinkAnimationTick = Math.max(0, this.drinkAnimationTick - 1);
                this.mob.setIsDrinking(this.drinkAnimationTick != this.adjustedTickDelay(4));
            }
        } else {
            this.mob.setIsDrinking(false);
        }
    }

    public void stop() {
        this.mob.setIsDrinking(false);
    }

    public int getDrinkAnimationTick() {
        return this.drinkAnimationTick;
    }
}

