/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.event;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.block.FrostedGrassBlock;
import com.farcr.nomansland.common.block.torches.ExtinguishedTorchBlock;
import com.farcr.nomansland.common.block.torches.ExtinguishedWallTorchBlock;
import com.farcr.nomansland.common.block.torches.SconceTorchBlock;
import com.farcr.nomansland.common.block.torches.SconceWallTorchBlock;
import com.farcr.nomansland.common.definitions.BlockDefinition;
import com.farcr.nomansland.common.entity.bombs.ExplosiveEntity;
import com.farcr.nomansland.common.registry.NMLCriteriaTriggers;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.worldgen.NMLFeatures;
import com.farcr.nomansland.common.saved_data.WardedSpacesData;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.DefaultBlockInteractionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;

@EventBusSubscriber(modid="nomansland")
public class MiscellaneousEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Direction ladderFacing;
        BlockState stateUnder;
        BlockPos posUnder;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        List<Block> torches = List.of(Blocks.TORCH, Blocks.WALL_TORCH, Blocks.SOUL_TORCH, Blocks.SOUL_WALL_TORCH, (Block)NMLBlocks.SCONCE_TORCH.get(), (Block)NMLBlocks.SCONCE_WALL_TORCH.get(), (Block)NMLBlocks.SCONCE_SOUL_TORCH.get(), (Block)NMLBlocks.SCONCE_SOUL_WALL_TORCH.get());
        if (torches.contains(state.getBlock()) && stack.is(ItemTags.SHOVELS) && !player.isSpectator() && ((Boolean)NMLConfig.TORCH_EXTINGUISHING.get()).booleanValue()) {
            level.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.4f, 1.0f);
            if (!level.isClientSide) {
                stack.hurtAndBreak(1, (LivingEntity)player, stack.getEquipmentSlot());
                BlockState extinguishedTorchState = ((TorchBlock)((BlockDefinition)((Object)ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry(Blocks.TORCH, NMLBlocks.EXTINGUISHED_TORCH), Map.entry(Blocks.WALL_TORCH, NMLBlocks.EXTINGUISHED_WALL_TORCH), Map.entry(Blocks.SOUL_TORCH, NMLBlocks.EXTINGUISHED_SOUL_TORCH), Map.entry(Blocks.SOUL_WALL_TORCH, NMLBlocks.EXTINGUISHED_SOUL_WALL_TORCH), Map.entry((SconceTorchBlock)((Object)NMLBlocks.SCONCE_TORCH.get()), NMLBlocks.EXTINGUISHED_SCONCE_TORCH), Map.entry((SconceWallTorchBlock)((Object)NMLBlocks.SCONCE_WALL_TORCH.get()), NMLBlocks.EXTINGUISHED_SCONCE_WALL_TORCH), Map.entry((SconceTorchBlock)((Object)NMLBlocks.SCONCE_SOUL_TORCH.get()), NMLBlocks.EXTINGUISHED_SCONCE_SOUL_TORCH), Map.entry((SconceWallTorchBlock)((Object)NMLBlocks.SCONCE_SOUL_WALL_TORCH.get()), NMLBlocks.EXTINGUISHED_SCONCE_SOUL_WALL_TORCH)}).get((Object)state.getBlock()))).value()).withPropertiesOf(state);
                level.setBlockAndUpdate(pos, extinguishedTorchState);
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
        if (state.hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && stack.is(NMLTags.FIRESTARTERS) && !stack.is(Items.FLINT_AND_STEEL)) {
            level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
        if (stack.is(Blocks.SNOW.asItem()) && !player.isSpectator() && state.is(Blocks.SHORT_GRASS)) {
            level.setBlockAndUpdate(pos, (BlockState)((FrostedGrassBlock)((Object)NMLBlocks.FROSTED_GRASS.get())).defaultBlockState().setValue((Property)FrostedGrassBlock.SNOWLOGGED, (Comparable)Boolean.valueOf(true)));
            stack.consume(1, (LivingEntity)player);
            level.playSound(player, pos, SoundEvents.SNOW_PLACE, SoundSource.PLAYERS, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.6f + 1.2f);
            posUnder = pos.below();
            stateUnder = level.getBlockState(posUnder);
            if (stateUnder.getBlock() instanceof SnowyDirtBlock) {
                level.setBlockAndUpdate(posUnder, (BlockState)stateUnder.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)));
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
        if ((stack.is(NMLBlocks.FROSTED_GRASS.asItem()) || stack.is(Blocks.SHORT_GRASS.asItem())) && !player.isSpectator() && state.is(Blocks.SNOW) && (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) < 3 && ((stateUnder = level.getBlockState(posUnder = pos.below())).getBlock() instanceof SnowyDirtBlock || stateUnder.getBlock() == Blocks.DIRT)) {
            level.setBlockAndUpdate(pos, (BlockState)((FrostedGrassBlock)((Object)NMLBlocks.FROSTED_GRASS.get())).defaultBlockState().setValue((Property)FrostedGrassBlock.SNOWLOGGED, (Comparable)Boolean.valueOf(true)));
            stack.consume(1, (LivingEntity)player);
            level.playSound(player, pos, SoundEvents.GRASS_PLACE, SoundSource.PLAYERS, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.2f + 1.2f);
            if (stateUnder.getBlock() instanceof SnowyDirtBlock) {
                level.setBlockAndUpdate(posUnder, (BlockState)stateUnder.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)));
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
        if (stack.is(Items.LADDER) && state.is(Blocks.LADDER) && !player.isSpectator() && !player.isCrouching() && !player.isFakePlayer() && (ladderFacing = (Direction)state.getValue((Property)LadderBlock.FACING)) == event.getFace()) {
            BlockPos.MutableBlockPos mutable = pos.below().mutable();
            for (int i = 0; i < (Integer)NMLConfig.MAX_LADDER_PLACEMENT_LENGTH.get(); ++i) {
                BlockState state2 = level.getBlockState((BlockPos)mutable);
                if (state2.is(BlockTags.REPLACEABLE)) {
                    if (state.canSurvive((LevelReader)level, (BlockPos)mutable)) {
                        SoundType soundtype = state.getSoundType((LevelReader)level, pos, (Entity)player);
                        level.playSound(player, (BlockPos)mutable, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                        stack.consume(1, (LivingEntity)player);
                        level.setBlockAndUpdate((BlockPos)mutable, (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)ladderFacing));
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                        break;
                    }
                } else if (!state2.is(Blocks.LADDER)) break;
                mutable.move(Direction.DOWN);
            }
        }
        if (stack.is(ItemTags.RAILS) && state.is(BlockTags.RAILS) && !player.isSpectator() && !player.isCrouching() && !player.isFakePlayer()) {
            Direction playerDir = player.getDirection();
            RailShape railShape = null;
            if (state.getBlock() instanceof BaseRailBlock) {
                railShape = (RailShape)state.getValue(((BaseRailBlock)state.getBlock()).getShapeProperty());
            }
            if (railShape != null) {
                int railCount = 0;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!level.getBlockState(pos.relative(direction)).is(BlockTags.RAILS)) continue;
                    ++railCount;
                }
                BlockPos.MutableBlockPos mutable = pos.mutable();
                for (int i = 0; i <= (Integer)NMLConfig.MAX_RAIL_PLACMENT_LENGTH.get(); ++i) {
                    BlockPos m = mutable.immutable();
                    BlockPos mBelow = m.below();
                    BlockPos mAbove = m.above();
                    BlockPos mBelow2 = mBelow.below();
                    BlockPos mSlopeBase = mBelow.relative(playerDir.getOpposite());
                    BlockState stateBase = level.getBlockState(m);
                    BlockState stateBelow = level.getBlockState(mBelow);
                    BlockState stateAbove = level.getBlockState(mAbove);
                    BlockState stateBelow2 = level.getBlockState(mBelow2);
                    BlockState stateSlopeBase = level.getBlockState(mSlopeBase);
                    if (stateBase.is(BlockTags.RAILS)) {
                        RailShape offsetShape = null;
                        if (stateBase.getBlock() instanceof BaseRailBlock) {
                            offsetShape = (RailShape)stateBase.getValue(((BaseRailBlock)stateBase.getBlock()).getShapeProperty());
                        }
                        if (offsetShape == null) break;
                        if (offsetShape == RailShape.NORTH_EAST) {
                            if (playerDir == Direction.SOUTH) {
                                playerDir = Direction.EAST;
                            } else if (playerDir == Direction.WEST) {
                                playerDir = Direction.NORTH;
                            }
                        } else if (offsetShape == RailShape.NORTH_WEST) {
                            if (playerDir == Direction.SOUTH) {
                                playerDir = Direction.WEST;
                            } else if (playerDir == Direction.EAST) {
                                playerDir = Direction.NORTH;
                            }
                        } else if (offsetShape == RailShape.SOUTH_EAST) {
                            if (playerDir == Direction.NORTH) {
                                playerDir = Direction.EAST;
                            } else if (playerDir == Direction.WEST) {
                                playerDir = Direction.SOUTH;
                            }
                        } else if (offsetShape == RailShape.SOUTH_WEST) {
                            if (playerDir == Direction.NORTH) {
                                playerDir = Direction.WEST;
                            } else if (playerDir == Direction.EAST) {
                                playerDir = Direction.SOUTH;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_NORTH) {
                            if (playerDir == Direction.NORTH) {
                                mutable.move(Direction.UP);
                            } else if (playerDir != Direction.SOUTH) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_SOUTH) {
                            if (playerDir == Direction.SOUTH) {
                                mutable.move(Direction.UP);
                            } else if (playerDir != Direction.NORTH) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_EAST) {
                            if (playerDir == Direction.EAST) {
                                mutable.move(Direction.UP);
                            } else if (playerDir != Direction.WEST) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_WEST) {
                            if (playerDir == Direction.WEST) {
                                mutable.move(Direction.UP);
                            } else if (playerDir != Direction.EAST) {
                                break;
                            }
                        } else if (offsetShape != RailShape.EAST_WEST && offsetShape != RailShape.NORTH_SOUTH) break;
                        mutable.move(playerDir);
                        continue;
                    }
                    if (stateBelow.is(BlockTags.RAILS)) {
                        boolean canGoDown = false;
                        RailShape offsetShape = null;
                        if (stateBelow.getBlock() instanceof BaseRailBlock) {
                            offsetShape = (RailShape)stateBelow.getValue(((BaseRailBlock)stateBelow.getBlock()).getShapeProperty());
                        }
                        if (offsetShape == null) break;
                        if (offsetShape == RailShape.ASCENDING_NORTH) {
                            if (playerDir == Direction.SOUTH) {
                                mutable.move(Direction.DOWN);
                                canGoDown = true;
                            } else if (playerDir != Direction.NORTH) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_SOUTH) {
                            if (playerDir == Direction.NORTH) {
                                mutable.move(Direction.DOWN);
                                canGoDown = true;
                            } else if (playerDir != Direction.SOUTH) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_EAST) {
                            if (playerDir == Direction.WEST) {
                                mutable.move(Direction.DOWN);
                                canGoDown = true;
                            } else if (playerDir != Direction.EAST) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_WEST) {
                            if (playerDir == Direction.EAST) {
                                mutable.move(Direction.DOWN);
                                canGoDown = true;
                            } else if (playerDir != Direction.WEST) break;
                        }
                        if (canGoDown) continue;
                        if (!stateBase.is(BlockTags.REPLACEABLE)) break;
                        if (!MiscellaneousEvents.placeRail(mutable.immutable(), stack, playerDir, level, player)) continue;
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                        break;
                    }
                    if (stateBase.isFaceSturdy((BlockGetter)level, (BlockPos)mutable, Direction.UP, SupportType.RIGID) && stateAbove.is(BlockTags.REPLACEABLE)) {
                        if (!MiscellaneousEvents.placeRail(mutable.immutable().above(), stack, playerDir, level, player)) continue;
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                        break;
                    }
                    if (stateBelow2.isFaceSturdy((BlockGetter)level, mutable.immutable().below(2), Direction.UP, SupportType.RIGID) && stateSlopeBase.isFaceSturdy((BlockGetter)level, mutable.immutable().below().relative(playerDir.getOpposite()), playerDir, SupportType.RIGID) && stateBelow.is(BlockTags.REPLACEABLE)) {
                        if (!MiscellaneousEvents.placeRail(mutable.immutable().below(), stack, playerDir, level, player)) continue;
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                        break;
                    }
                    if (!stateBase.is(BlockTags.REPLACEABLE)) break;
                    if (!MiscellaneousEvents.placeRail(mutable.immutable(), stack, playerDir, level, player)) continue;
                    event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                    event.setCanceled(true);
                    break;
                }
            }
        }
    }

    private static boolean placeRail(BlockPos position, ItemStack stack, Direction playerDir, Level level, Player player) {
        RailShape placedShape;
        BlockState state = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
        switch (playerDir) {
            case NORTH: 
            case SOUTH: {
                RailShape railShape = RailShape.NORTH_SOUTH;
                break;
            }
            case EAST: 
            case WEST: {
                RailShape railShape = RailShape.EAST_WEST;
                break;
            }
            default: {
                RailShape railShape = placedShape = null;
            }
        }
        if (state.getBlock() instanceof BaseRailBlock) {
            state = (BlockState)state.setValue(((BaseRailBlock)state.getBlock()).getShapeProperty(), (Comparable)placedShape);
        }
        if (state.canSurvive((LevelReader)level, position)) {
            SoundType soundtype = state.getSoundType((LevelReader)level, position, (Entity)player);
            level.playSound(player, position, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            stack.consume(1, (LivingEntity)player);
            level.setBlockAndUpdate(position, state);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onFinalizeMobSpawn(FinalizeSpawnEvent event) {
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
            if (event.getSpawnType() == MobSpawnType.NATURAL && event.getEntity() instanceof Monster) {
                WardedSpacesData wardedSpacesData = (WardedSpacesData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new WardedSpacesData(new ArrayList<BlockPos>(), new ArrayList<Integer>()), WardedSpacesData::load), "warded_spaces");
                event.setSpawnCancelled(wardedSpacesData.isWarded(event.getEntity().blockPosition()));
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        Level level = event.getLevel();
        event.getAffectedBlocks().forEach(pos -> {
            ExplosiveEntity explosive;
            Entity patt1$temp;
            Entity patt0$temp;
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() instanceof TorchBlock && !(state.getBlock() instanceof ExtinguishedTorchBlock)) {
                level.gameEvent(explosion.getDirectSourceEntity(), (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (state.is(Blocks.TORCH)) {
                    level.setBlock(pos, ((ExtinguishedTorchBlock)((Object)((Object)NMLBlocks.EXTINGUISHED_TORCH.get()))).withPropertiesOf(state), 11);
                }
                if (state.is(Blocks.WALL_TORCH)) {
                    level.setBlock(pos, ((ExtinguishedWallTorchBlock)((Object)((Object)NMLBlocks.EXTINGUISHED_WALL_TORCH.get()))).withPropertiesOf(state), 11);
                }
                if (state.is(Blocks.SOUL_TORCH)) {
                    level.setBlock(pos, ((ExtinguishedTorchBlock)((Object)((Object)NMLBlocks.EXTINGUISHED_SOUL_TORCH.get()))).withPropertiesOf(state), 11);
                }
                if (state.is(Blocks.SOUL_WALL_TORCH)) {
                    level.setBlock(pos, ((ExtinguishedWallTorchBlock)((Object)((Object)NMLBlocks.EXTINGUISHED_SOUL_WALL_TORCH.get()))).withPropertiesOf(state), 11);
                }
            }
            if ((patt0$temp = event.getExplosion().getDirectSourceEntity()) instanceof ExplosiveEntity && (patt1$temp = (explosive = (ExplosiveEntity)patt0$temp).getOwner()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt1$temp;
                if (state.is(Tags.Blocks.ORES)) {
                    ((DefaultBlockInteractionTrigger)NMLCriteriaTriggers.MINE_ORE_WITH_EXPLOSIVE.get()).trigger(serverPlayer, pos);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (!((Boolean)NMLConfig.TRAMPLING.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockGrow(BlockGrowFeatureEvent event) {
        ResourceKey feature = event.getFeature().getKey();
        List<ResourceKey> regularOakFeatures = List.of(TreeFeatures.OAK, TreeFeatures.OAK_BEES_0002, TreeFeatures.OAK_BEES_002, TreeFeatures.OAK_BEES_005);
        List<ResourceKey> fancyOakFeatures = List.of(TreeFeatures.FANCY_OAK, TreeFeatures.FANCY_OAK_BEES_0002, TreeFeatures.FANCY_OAK_BEES_002, TreeFeatures.FANCY_OAK_BEES_005);
        List<ResourceKey<ConfiguredFeature<?, ?>>> autumnalOakFeatures = List.of(NMLFeatures.AUTUMNAL_OAK, NMLFeatures.LARGE_AUTUMNAL_OAK);
        List<ResourceKey> spruceFeatures = List.of(TreeFeatures.SPRUCE, TreeFeatures.MEGA_SPRUCE, TreeFeatures.PINE, TreeFeatures.MEGA_PINE);
        List<ResourceKey<ConfiguredFeature<?, ?>>> pineFeatures = List.of(NMLFeatures.PINE, NMLFeatures.LARGE_PINE);
        BlockPos pos = event.getPos();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        LevelAccessor level = event.getLevel();
        int fruit = 0;
        RandomSource random = event.getRandom();
        boolean apple = regularOakFeatures.contains(feature) || fancyOakFeatures.contains(feature);
        boolean pear = autumnalOakFeatures.contains(feature);
        if (apple || pear) {
            Iterator it = BlockPos.betweenClosedStream((int)(x - 8), (int)(y - 12), (int)(z - 8), (int)(x + 8), (int)(y + 12), (int)(z + 8)).iterator();
            while (it.hasNext()) {
                BlockPos bp = (BlockPos)it.next();
                BlockState state = level.getBlockState(bp);
                if (apple && state.is(NMLBlocks.APPLE_FRUIT.block())) {
                    ++fruit;
                }
                if (!pear || !state.is(NMLBlocks.PEAR_FRUIT.block())) continue;
                ++fruit;
            }
            if (fruit >= 12) {
                if (regularOakFeatures.contains(feature)) {
                    event.setFeature(NMLFeatures.OAK_APPLE_05);
                }
                if (fancyOakFeatures.contains(feature)) {
                    event.setFeature(NMLFeatures.FANCY_OAK_APPLE_05);
                }
                if (feature == NMLFeatures.AUTUMNAL_OAK) {
                    event.setFeature(NMLFeatures.AUTUMNAL_OAK_PEAR_05);
                }
                if (feature == NMLFeatures.LARGE_AUTUMNAL_OAK) {
                    event.setFeature(NMLFeatures.LARGE_AUTUMNAL_OAK_PEAR_05);
                }
            } else if (random.nextBoolean() && fruit >= 6) {
                if (regularOakFeatures.contains(feature)) {
                    event.setFeature(NMLFeatures.OAK_APPLE_05);
                }
                if (fancyOakFeatures.contains(feature)) {
                    event.setFeature(NMLFeatures.FANCY_OAK_APPLE_05);
                }
                if (feature == NMLFeatures.AUTUMNAL_OAK) {
                    event.setFeature(NMLFeatures.AUTUMNAL_OAK_PEAR_05);
                }
                if (feature == NMLFeatures.LARGE_AUTUMNAL_OAK) {
                    event.setFeature(NMLFeatures.LARGE_AUTUMNAL_OAK_PEAR_05);
                }
            } else if (fruit > 0) {
                if (regularOakFeatures.contains(feature)) {
                    event.setFeature(NMLFeatures.OAK_APPLE_01);
                }
                if (fancyOakFeatures.contains(feature)) {
                    event.setFeature(NMLFeatures.FANCY_OAK_APPLE_01);
                }
            }
        }
        if ((spruceFeatures.contains(feature) || pineFeatures.contains(feature)) && level.getLevelData().isRaining() && !((Biome)level.getBiome(pos).value()).warmEnoughToRain(pos)) {
            if (spruceFeatures.contains(feature)) {
                if (feature == TreeFeatures.SPRUCE) {
                    event.setFeature(NMLFeatures.FROSTED_SPRUCE);
                }
                if (feature == TreeFeatures.MEGA_SPRUCE) {
                    event.setFeature(NMLFeatures.MEGA_FROSTED_SPRUCE);
                }
                if (feature == TreeFeatures.PINE) {
                    event.setFeature(NMLFeatures.FROSTED_SPRUCE_ALT);
                }
                if (feature == TreeFeatures.MEGA_PINE) {
                    event.setFeature(NMLFeatures.MEGA_FROSTED_SPRUCE_ALT);
                }
            }
            if (pineFeatures.contains(feature)) {
                event.setFeature(NMLFeatures.FROSTED_PINE);
            }
        }
    }
}

