/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    @Final
    protected RandomSource random;
    @Shadow
    private EntityDimensions dimensions;
    @Shadow
    public float fallDistance;
    @Unique
    @Nullable
    private Vec3 startingToFallPosition;

    @Shadow
    public abstract void playSound(SoundEvent var1, float var2, float var3);

    @Shadow
    public abstract double getY();

    @Shadow
    public abstract double getY(double var1);

    @Shadow
    public abstract double getZ();

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract EntityType<?> getType();

    @Shadow
    public abstract BlockPos blockPosition();

    @Shadow
    public abstract EntityDimensions getDimensions(Pose var1);

    @Shadow
    public abstract Pose getPose();

    @Shadow
    public abstract Set<String> getTags();

    @Shadow
    public abstract BlockPos getOnPos();

    @Shadow
    protected abstract BlockPos getOnPos(float var1);

    @Shadow
    public abstract BlockState getBlockStateOn();

    @Shadow
    public abstract Vec3 position();

    @Shadow
    public abstract boolean onGround();

    @Shadow
    public abstract boolean isInWater();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(EntityType<?> entityType, Level level, CallbackInfo ci) {
        if (entityType == EntityType.COW) {
            this.dimensions = this.getDimensions(this.getPose()) == null ? entityType.getDimensions() : this.getDimensions(this.getPose());
        }
    }

    @Inject(method={"getOnPosLegacy"}, at={@At(value="RETURN")}, cancellable=true)
    private void getOnPosLegacy(CallbackInfoReturnable<BlockPos> cir) {
        cir.setReturnValue((Object)(this.getBlockStateOn().is(NMLBlocks.SPIKE_TRAP.block()) ? this.getOnPos() : this.getOnPos(0.2f)));
    }

    @Inject(method={"resetFallDistance"}, at={@At(value="HEAD")})
    private void resetFallDistance(CallbackInfo ci) {
        LivingEntity livingEntity;
        Entity entity2 = (Entity)this;
        if (entity2 instanceof LivingEntity && (livingEntity = (LivingEntity)entity2).getHealth() > 0.0f && this.startingToFallPosition != null && !livingEntity.getPassengers().isEmpty()) {
            livingEntity.getPassengers().forEach(entity -> {
                ServerPlayer player;
                if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).getHealth() > 0.0f) {
                    CriteriaTriggers.FALL_FROM_HEIGHT.trigger(player, this.startingToFallPosition);
                }
            });
        }
        this.startingToFallPosition = null;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        this.trackStartFallingPosition();
    }

    @Unique
    private void trackStartFallingPosition() {
        if (this.fallDistance > 0.0f && this.startingToFallPosition == null) {
            this.startingToFallPosition = this.position();
        }
    }
}

