/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.farcr.nomansland.common.mixin.EntityMixin;
import com.farcr.nomansland.common.mixinduck.LivingEntityDuck;
import com.farcr.nomansland.common.registry.entities.NMLEffects;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements LivingEntityDuck {
    @Unique
    private boolean nomansland$skipDroppingDeathLoot = false;

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    @Override
    public void nml$skipDroppingDeathLoot() {
        this.nomansland$skipDroppingDeathLoot = true;
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="HEAD")}, cancellable=true)
    private void trySkipDroppingDeathLoot(ServerLevel p_level, DamageSource damageSource, CallbackInfo ci) {
        if (this.nomansland$skipDroppingDeathLoot) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"travel"}, at=@At(value="STORE"), ordinal=0)
    public float tryReduceFriction(float value) {
        return this.hasEffect((Holder<MobEffect>)NMLEffects.FLAMMABLE) && !this.isInWater() && this.onGround() ? 0.98f : value;
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="RETURN")}, cancellable=true)
    private void tryReduceBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        if (this.hasEffect((Holder<MobEffect>)NMLEffects.FLAMMABLE) && !this.isInWater()) {
            cir.setReturnValue((Object)Float.valueOf(0.95f));
        }
    }
}

