/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RailState.class})
public abstract class RailStateMixin {
    @Shadow
    @Final
    private Level level;
    @Shadow
    private BlockState state;
    @Shadow
    @Final
    private BaseRailBlock block;
    @Shadow
    @Final
    public BlockPos pos;
    @Shadow
    @Final
    private List<BlockPos> connections;

    @Shadow
    protected abstract void updateConnections(RailShape var1);

    @Shadow
    @Nullable
    protected abstract RailState getRail(BlockPos var1);

    @Shadow
    protected abstract boolean hasNeighborRail(BlockPos var1);

    @Shadow
    public abstract boolean hasConnection(BlockPos var1);

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    public void nml$place(boolean powered, boolean alwaysPlace, RailShape shape, CallbackInfoReturnable<RailState> cir) {
        BlockPos blockpos = this.pos.north();
        BlockPos blockpos1 = this.pos.south();
        BlockPos blockpos2 = this.pos.west();
        BlockPos blockpos3 = this.pos.east();
        boolean flag = this.hasNeighborRail(blockpos);
        boolean flag1 = this.hasNeighborRail(blockpos1);
        boolean flag2 = this.hasNeighborRail(blockpos2);
        boolean flag3 = this.hasNeighborRail(blockpos3);
        RailShape railshape = null;
        boolean flag4 = flag || flag1;
        boolean flag5 = flag2 || flag3;
        boolean supported = this.level.getBlockState(this.pos.below()).isFaceSturdy((BlockGetter)this.level, this.pos.below(), Direction.UP, SupportType.RIGID);
        if (flag4 && !supported) {
            railshape = RailShape.NORTH_SOUTH;
        }
        if (flag5 && !supported) {
            railshape = RailShape.EAST_WEST;
        }
        if (railshape != null) {
            this.updateConnections(railshape);
            this.state = (BlockState)this.state.setValue(this.block.getShapeProperty(), (Comparable)railshape);
            if (alwaysPlace || this.level.getBlockState(this.pos) != this.state) {
                this.level.setBlock(this.pos, this.state, 3);
                for (BlockPos connection : this.connections) {
                    RailState railstate = this.getRail(connection);
                    if (railstate == null) continue;
                    railstate.removeSoftConnections();
                    if (!railstate.canConnectTo((RailState)this)) continue;
                    railstate.connectTo((RailState)this);
                }
            }
            cir.setReturnValue((Object)((RailState)this));
        }
    }

    @Inject(method={"connectTo"}, at={@At(value="HEAD")}, cancellable=true)
    public void nml$connectTo(RailState state, CallbackInfo ci) {
        boolean supported;
        this.connections.add(state.pos);
        BlockPos blockpos = this.pos.north();
        BlockPos blockpos1 = this.pos.south();
        BlockPos blockpos2 = this.pos.west();
        BlockPos blockpos3 = this.pos.east();
        boolean flag = this.hasConnection(blockpos);
        boolean flag1 = this.hasConnection(blockpos1);
        boolean flag2 = this.hasConnection(blockpos2);
        boolean flag3 = this.hasConnection(blockpos3);
        RailShape railshape = null;
        if (flag || flag1) {
            railshape = RailShape.NORTH_SOUTH;
        }
        if (flag2 || flag3) {
            railshape = RailShape.EAST_WEST;
        }
        if (!(supported = this.level.getBlockState(this.pos.below()).isFaceSturdy((BlockGetter)this.level, this.pos.below(), Direction.UP, SupportType.RIGID))) {
            if (railshape == null) {
                railshape = RailShape.NORTH_SOUTH;
            }
            if (!this.block.isValidRailShape(railshape)) {
                this.connections.remove(state.pos);
                ci.cancel();
            }
            this.state = (BlockState)this.state.setValue(this.block.getShapeProperty(), (Comparable)railshape);
            this.level.setBlock(this.pos, this.state, 3);
            ci.cancel();
        }
    }
}

