/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.registry.items;

import com.farcr.nomansland.NMLEnumParams;
import com.farcr.nomansland.common.definitions.ItemDefinition;
import com.farcr.nomansland.common.item.ExplosiveItem;
import com.farcr.nomansland.common.item.FirebombItem;
import com.farcr.nomansland.common.item.FuelItem;
import com.farcr.nomansland.common.item.HoneyFoodItem;
import com.farcr.nomansland.common.item.MapleFoodItem;
import com.farcr.nomansland.common.item.MapleSyrupBottleItem;
import com.farcr.nomansland.common.item.ResinOilBottleItem;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.entities.NMLEffects;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.farcr.nomansland.common.registry.items.NMLFoods;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.ScaffoldingBlockItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NMLItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"nomansland");
    public static List<ItemDefinition<?>> ITEM_DEFINITIONS = new ArrayList();
    public BuildCreativeModeTabContentsEvent event = null;
    public static final ItemDefinition<Item> NO_MANS_GLOBE = NMLItems.registerWithoutTab("no_mans_globe", () -> new Item(new Item.Properties()), true);
    public static final ItemDefinition<Item> TRINKET = NMLItems.registerWithoutTab("trinket", () -> new Item(new Item.Properties()));
    public static LinkedHashSet<ItemDefinition<?>> CREATIVE_TAB_ITEMS = Sets.newLinkedHashSet();
    public static final ItemDefinition<Item> MASHED_POTATOES_WITH_MUSHROOMS = NMLItems.register("mashed_potatoes_with_mushrooms", () -> new Item(new Item.Properties().food(NMLFoods.MASHED_POTATOES_WITH_MUSHROOMS).stacksTo(1)), true);
    public static final ItemDefinition<Item> GRILLED_MUSHROOMS = NMLItems.register("grilled_mushrooms", () -> new Item(new Item.Properties().food(NMLFoods.GRILLED_MUSHROOMS)));
    public static final ItemDefinition<Item> FROG_LEG = NMLItems.register("frog_leg", () -> new Item(new Item.Properties().food(NMLFoods.FROG_LEG)));
    public static final ItemDefinition<Item> COOKED_FROG_LEG = NMLItems.register("cooked_frog_leg", () -> new Item(new Item.Properties().food(NMLFoods.COOKED_FROG_LEG)));
    public static final ItemDefinition<Item> RAW_HORSE = NMLItems.register("raw_horse", () -> new Item(new Item.Properties().food(NMLFoods.RAW_HORSE)));
    public static final ItemDefinition<Item> HORSE_STEAK = NMLItems.register("horse_steak", () -> new Item(new Item.Properties().food(NMLFoods.HORSE_STEAK)));
    public static final ItemDefinition<Item> RAW_VENISON = NMLItems.register("raw_venison", () -> new Item(new Item.Properties().food(NMLFoods.RAW_VENISON)));
    public static final ItemDefinition<Item> COOKED_VENISON = NMLItems.register("cooked_venison", () -> new Item(new Item.Properties().food(NMLFoods.COOKED_VENISON)));
    public static final ItemDefinition<Item> BILLHOOK_BASS = NMLItems.register("billhook_bass", () -> new Item(new Item.Properties().food(NMLFoods.BILLHOOK_BASS)), true);
    public static final ItemDefinition<Item> COOKED_BILLHOOK_BASS = NMLItems.register("cooked_billhook_bass", () -> new Item(new Item.Properties().food(NMLFoods.COOKED_BILLHOOK_BASS)));
    public static final ItemDefinition<Item> PEAR = NMLItems.register("pear", () -> new Item(new Item.Properties().food(NMLFoods.PEAR)));
    public static final ItemDefinition<Item> SYRUPED_PEAR = NMLItems.register("syruped_pear", () -> new MapleFoodItem(new Item.Properties().food(NMLFoods.SYRUPED_PEAR)));
    public static final ItemDefinition<Item> PANCAKE = NMLItems.register("pancake", () -> new MapleFoodItem(new Item.Properties().food(NMLFoods.PANCAKE)));
    public static final ItemDefinition<Item> HONEYED_APPLE = NMLItems.register("honeyed_apple", () -> new HoneyFoodItem(new Item.Properties().food(NMLFoods.HONEYED_APPLE)));
    public static final ItemDefinition<Item> WALNUTS = NMLItems.register("walnuts", () -> new Item(new Item.Properties().food(NMLFoods.WALNUTS)));
    public static final ItemDefinition<Item> MAPLE_SYRUP_BOTTLE = NMLItems.register("maple_syrup_bottle", () -> new MapleSyrupBottleItem(new Item.Properties().food(NMLFoods.MAPLE_SYRUP_BOTTLE).craftRemainder(Items.GLASS_BOTTLE).stacksTo(16)));
    public static final ItemDefinition<Item> RESIN = NMLItems.register("resin", () -> new FuelItem(new Item.Properties(), 1000));
    public static final ItemDefinition<Item> RESIN_OIL_BOTTLE = NMLItems.register("resin_oil_bottle", () -> new ResinOilBottleItem(new Item.Properties().stacksTo(16).craftRemainder(Items.GLASS_BOTTLE).component(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), List.of(new MobEffectInstance(NMLEffects.FLAMMABLE, 2400))))));
    public static final ItemDefinition<Item> SCONCE_TORCH = NMLItems.register("sconce_torch", () -> new StandingAndWallBlockItem((Block)NMLBlocks.SCONCE_TORCH.get(), (Block)NMLBlocks.SCONCE_WALL_TORCH.get(), new Item.Properties(), Direction.DOWN));
    public static final ItemDefinition<Item> SCONCE_SOUL_TORCH = NMLItems.register("sconce_soul_torch", () -> new StandingAndWallBlockItem((Block)NMLBlocks.SCONCE_SOUL_TORCH.get(), (Block)NMLBlocks.SCONCE_SOUL_WALL_TORCH.get(), new Item.Properties(), Direction.DOWN));
    public static final ItemDefinition<Item> FIREBOMB = NMLItems.register("firebomb", () -> new FirebombItem(new Item.Properties().stacksTo(8)));
    public static final ItemDefinition<Item> EXPLOSIVE = NMLItems.register("explosive", () -> new ExplosiveItem(new Item.Properties().stacksTo(8)));
    public static final ItemDefinition<Item> WOODEN_SCAFFOLDING = NMLItems.register("wooden_scaffolding", () -> new ScaffoldingBlockItem((Block)NMLBlocks.WOODEN_SCAFFOLDING.get(), new Item.Properties()));
    public static final ItemDefinition<Item> BILLHOOK_BASS_BUCKET = NMLItems.register("billhook_bass_bucket", () -> new MobBucketItem(NMLEntities.BILLHOOK_BASS.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().stacksTo(1).component(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY)), true);
    public static final ItemDefinition<Item> BILLHOOK_BASS_SPAWN_EGG = NMLItems.register("billhook_bass_spawn_egg", () -> new DeferredSpawnEggItem(NMLEntities.BILLHOOK_BASS, 6443553, 11236417, new Item.Properties()));
    public static final ItemDefinition<Item> DEER_SPAWN_EGG = NMLItems.register("deer_spawn_egg", () -> new DeferredSpawnEggItem(NMLEntities.DEER, 8412743, 12828347, new Item.Properties()));
    public static final ItemDefinition<Item> GOOSE_SPAWN_EGG = NMLItems.register("goose_spawn_egg", () -> new DeferredSpawnEggItem(NMLEntities.GOOSE, 11773851, 11888408, new Item.Properties()));
    public static final ItemDefinition<Item> MOOSE_SPAWN_EGG = NMLItems.register("moose_spawn_egg", () -> new DeferredSpawnEggItem(NMLEntities.MOOSE, 4335898, 2497045, new Item.Properties()));
    public static final ItemDefinition<Item> PINE_SIGN = NMLItems.register("pine_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)NMLBlocks.PINE.sign().get(), (Block)NMLBlocks.PINE.wallSign().get()));
    public static final ItemDefinition<Item> PINE_HANGING_SIGN = NMLItems.register("pine_hanging_sign", () -> new HangingSignItem((Block)NMLBlocks.PINE.hangingSign().get(), (Block)NMLBlocks.PINE.hangingWallSign().get(), new Item.Properties().stacksTo(16)));
    public static final ItemDefinition<Item> PINE_BOAT = NMLItems.register("pine_boat", () -> new BoatItem(false, (Boat.Type)NMLEnumParams.PINE_BOAT_TYPE.getValue(), new Item.Properties().stacksTo(1)));
    public static final ItemDefinition<Item> PINE_CHEST_BOAT = NMLItems.register("pine_chest_boat", () -> new BoatItem(true, (Boat.Type)NMLEnumParams.PINE_BOAT_TYPE.getValue(), new Item.Properties().stacksTo(1)), true);
    public static final ItemDefinition<Item> MAPLE_SIGN = NMLItems.register("maple_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)NMLBlocks.MAPLE.sign().get(), (Block)NMLBlocks.MAPLE.wallSign().get()));
    public static final ItemDefinition<Item> MAPLE_HANGING_SIGN = NMLItems.register("maple_hanging_sign", () -> new HangingSignItem((Block)NMLBlocks.MAPLE.hangingSign().get(), (Block)NMLBlocks.MAPLE.hangingWallSign().get(), new Item.Properties().stacksTo(16)));
    public static final ItemDefinition<Item> MAPLE_BOAT = NMLItems.register("maple_boat", () -> new BoatItem(false, (Boat.Type)NMLEnumParams.MAPLE_BOAT_TYPE.getValue(), new Item.Properties().stacksTo(1)));
    public static final ItemDefinition<Item> MAPLE_CHEST_BOAT = NMLItems.register("maple_chest_boat", () -> new BoatItem(true, (Boat.Type)NMLEnumParams.MAPLE_BOAT_TYPE.getValue(), new Item.Properties().stacksTo(1)), true);
    public static final ItemDefinition<Item> WALNUT_SIGN = NMLItems.register("walnut_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)NMLBlocks.WALNUT.sign().get(), (Block)NMLBlocks.WALNUT.wallSign().get()));
    public static final ItemDefinition<Item> WALNUT_HANGING_SIGN = NMLItems.register("walnut_hanging_sign", () -> new HangingSignItem((Block)NMLBlocks.WALNUT.hangingSign().get(), (Block)NMLBlocks.WALNUT.hangingWallSign().get(), new Item.Properties().stacksTo(16)));
    public static final ItemDefinition<Item> WALNUT_BOAT = NMLItems.register("walnut_boat", () -> new BoatItem(false, (Boat.Type)NMLEnumParams.WALNUT_BOAT_TYPE.getValue(), new Item.Properties().stacksTo(1)));
    public static final ItemDefinition<Item> WALNUT_CHEST_BOAT = NMLItems.register("walnut_chest_boat", () -> new BoatItem(true, (Boat.Type)NMLEnumParams.WALNUT_BOAT_TYPE.getValue(), new Item.Properties().stacksTo(1)), true);
    public static final ItemDefinition<Item> WILLOW_SIGN = NMLItems.register("willow_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)NMLBlocks.WILLOW.sign().get(), (Block)NMLBlocks.WILLOW.wallSign().get()));
    public static final ItemDefinition<Item> WILLOW_HANGING_SIGN = NMLItems.register("willow_hanging_sign", () -> new HangingSignItem((Block)NMLBlocks.WILLOW.hangingSign().get(), (Block)NMLBlocks.WILLOW.hangingWallSign().get(), new Item.Properties().stacksTo(16)));
    public static final ItemDefinition<Item> WILLOW_BOAT = NMLItems.register("willow_boat", () -> new BoatItem(false, (Boat.Type)NMLEnumParams.WILLOW_BOAT_TYPE.getValue(), new Item.Properties().stacksTo(1)));
    public static final ItemDefinition<Item> WILLOW_CHEST_BOAT = NMLItems.register("willow_chest_boat", () -> new BoatItem(true, (Boat.Type)NMLEnumParams.WILLOW_BOAT_TYPE.getValue(), new Item.Properties().stacksTo(1)), true);
    public static final ItemDefinition<Item> FIELD_MUSHROOM = NMLItems.register("field_mushroom", () -> new BlockItem((Block)NMLBlocks.FIELD_MUSHROOM.get(), new Item.Properties()));
    public static final ItemDefinition<Item> DUCKWEED = NMLItems.register("duckweed", () -> new PlaceOnWaterBlockItem((Block)NMLBlocks.DUCKWEED.get(), new Item.Properties()));
    public static final ItemDefinition<Item> WATER_MOSAIC = NMLItems.register("water_mosaic", () -> new PlaceOnWaterBlockItem((Block)NMLBlocks.WATER_MOSAIC.get(), new Item.Properties()));

    public static <T extends Item> ItemDefinition<T> registerWithoutTab(String name, Supplier<T> item, boolean customLang) {
        DeferredItem deferred = ITEMS.register(name, item);
        ItemDefinition definition = ItemDefinition.fromHolder(deferred, customLang);
        ITEM_DEFINITIONS.add(definition);
        return definition;
    }

    public static <T extends Item> ItemDefinition<T> register(String name, Supplier<T> item, boolean customLang) {
        ItemDefinition<T> definition = NMLItems.registerWithoutTab(name, item, customLang);
        CREATIVE_TAB_ITEMS.add(definition);
        return definition;
    }

    public static <T extends Item> ItemDefinition<T> registerWithoutTab(String name, Supplier<T> item) {
        return NMLItems.registerWithoutTab(name, item, false);
    }

    public static <T extends Item> ItemDefinition<T> register(String name, Supplier<T> item) {
        return NMLItems.register(name, item, false);
    }
}

