/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.registry.worldgen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class NMLBiomes {
    public static List<ResourceKey<Biome>> BIOMES = new ArrayList<ResourceKey<Biome>>();
    public static final ResourceKey<Biome> AUTUMNAL_FOREST = NMLBiomes.createKey("autumnal_forest");
    public static final ResourceKey<Biome> MAPLE_FOREST = NMLBiomes.createKey("maple_forest");
    public static final ResourceKey<Biome> MAPLE_GROVE = NMLBiomes.createKey("maple_grove");
    public static final ResourceKey<Biome> FROZEN_WOODS = NMLBiomes.createKey("frozen_woods");
    public static final ResourceKey<Biome> OLD_GROWTH_FOREST = NMLBiomes.createKey("old_growth_forest");
    public static final ResourceKey<Biome> OLD_GROWTH_FOREST_CLEARING = NMLBiomes.createKey("old_growth_forest_clearing");
    public static final ResourceKey<Biome> OLD_GROWTH_FOREST_EDGE = NMLBiomes.createKey("old_growth_forest_edge");
    public static final ResourceKey<Biome> DARK_TAIGA = NMLBiomes.createKey("dark_taiga");
    public static final ResourceKey<Biome> DARK_SWAMP = NMLBiomes.createKey("dark_swamp");
    public static final ResourceKey<Biome> BAYOU = NMLBiomes.createKey("bayou");
    public static final ResourceKey<Biome> BOG = NMLBiomes.createKey("bog");
    public static final ResourceKey<Biome> CAVES = NMLBiomes.createKey("caves");
    public static final ResourceKey<Biome> CAVE_DEPTHS = NMLBiomes.createKey("cave_depths");

    private static ResourceKey<Biome> createKey(String name) {
        ResourceKey biome = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)name));
        BIOMES.add((ResourceKey<Biome>)biome);
        return biome;
    }

    public static String langKey(ResourceKey<Biome> biome) {
        return "biome." + biome.location().toString().replaceAll(":", ".");
    }

    public static String langName(ResourceKey<Biome> biome) {
        String processed = biome.location().getPath().replace("_", " ");
        String[] words = processed.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }
}

