/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature;

import com.farcr.nomansland.common.world.feature.BoulderFeatureConfiguration;
import com.farcr.nomansland.common.world.feature.decorator.BoulderDecorator;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BoulderFeature
extends Feature<BoulderFeatureConfiguration> {
    public BoulderFeature(Codec<BoulderFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BoulderFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BoulderFeatureConfiguration config = (BoulderFeatureConfiguration)context.config();
        int numCubes = config.numCubes().sample(random);
        float cubeHeightDecrease = config.cubeHeightDecrease();
        HashSet<BlockPos> stonePos = new HashSet<BlockPos>();
        ArrayList decoPos = new ArrayList();
        ArrayList<BlockPos> cubeFloorPlan = new ArrayList<BlockPos>();
        cubeFloorPlan.add(origin);
        BlockPos.MutableBlockPos posMutable = origin.mutable();
        for (int i = 0; i < numCubes; ++i) {
            BlockPos cubeOrigin = (BlockPos)cubeFloorPlan.get(random.nextInt(cubeFloorPlan.size()));
            int cubeHeight = Math.max(config.cubeHeight().sample(random) - (int)(cubeHeightDecrease * (float)i), 0);
            int numErodedBlocks = config.numErodedBlocks().sample(random);
            ArrayList<BlockPos> topBlocks = new ArrayList<BlockPos>();
            cubeFloorPlan.remove(cubeOrigin);
            cubeFloorPlan.add(cubeOrigin.north().east());
            cubeFloorPlan.add(cubeOrigin.north().west());
            cubeFloorPlan.add(cubeOrigin.south().east());
            cubeFloorPlan.add(cubeOrigin.south().west());
            for (int x = cubeOrigin.getX(); x <= cubeOrigin.getX() + 1; ++x) {
                for (int z = cubeOrigin.getZ(); z <= cubeOrigin.getZ() + 1; ++z) {
                    for (int y = cubeOrigin.getY(); y <= cubeOrigin.getY() + cubeHeight; ++y) {
                        posMutable.set(x, y, z);
                        stonePos.add(posMutable.immutable());
                        if (y != cubeOrigin.getY() + cubeHeight) continue;
                        topBlocks.add(posMutable.immutable());
                    }
                    for (int j = 0; j < numErodedBlocks && !topBlocks.isEmpty(); ++j) {
                        int blockIdx = random.nextInt(topBlocks.size());
                        posMutable.set((Vec3i)topBlocks.get(blockIdx));
                        if (!level.getBlockState(posMutable.above()).isAir() || stonePos.contains(posMutable.above().immutable())) continue;
                        stonePos.remove(posMutable.immutable());
                        topBlocks.remove(blockIdx);
                    }
                }
            }
        }
        ArrayList<BlockPos> stonePosList = new ArrayList<BlockPos>();
        for (BlockPos pos : stonePos) {
            if (!level.getBlockState(pos).is(BlockTags.REPLACEABLE)) continue;
            stonePosList.add(pos);
        }
        stonePosList.sort(Comparator.comparingInt(Vec3i::getY));
        HashSet<BlockPos> gravityStonePos = new HashSet<BlockPos>();
        for (BlockPos pos : stonePosList) {
            int i;
            for (i = 0; i < 10 && level.getBlockState(pos.below(i)).is(BlockTags.REPLACEABLE) && !gravityStonePos.contains(pos.below(i)); ++i) {
            }
            if (i == 10) {
                return false;
            }
            gravityStonePos.add(pos.below(--i));
        }
        for (BlockPos pos : gravityStonePos) {
            level.setBlock(pos, config.blockProvider().getState(random, pos), 2);
        }
        BiConsumer<BlockPos, BlockState> decoratorConsumer = (pos1, state1) -> {
            decoPos.add(pos1.immutable());
            level.setBlock(pos1, state1, 19);
        };
        if (!config.decorators().isEmpty()) {
            BoulderDecorator.Context boulderdecorator$context = new BoulderDecorator.Context(level, decoratorConsumer, random, gravityStonePos, context.chunkGenerator());
            config.decorators().forEach(deco -> deco.place(boulderdecorator$context));
        }
        return true;
    }
}

