/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.decorator;

import com.farcr.nomansland.common.registry.worldgen.NMLFallenTreeDecoratorTypes;
import com.farcr.nomansland.common.world.feature.decorator.FallenTreeDecorator;
import com.farcr.nomansland.common.world.feature.decorator.FallenTreeDecoratorType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class ClusterSideFallenTreeDecorator
extends FallenTreeDecorator {
    public static final MapCodec<ClusterSideFallenTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(f -> Float.valueOf(f.probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("block_probability").forGetter(f -> Float.valueOf(f.blockProbability)), (App)Codec.intRange((int)0, (int)16).fieldOf("limit").forGetter(f -> f.limit), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(f -> f.blockProvider)).apply((Applicative)instance, ClusterSideFallenTreeDecorator::new));
    protected final float probability;
    protected final float blockProbability;
    protected final int limit;
    protected final BlockStateProvider blockProvider;

    public ClusterSideFallenTreeDecorator(float probability, float blockProbability, int limit, BlockStateProvider blockProvider) {
        this.probability = probability;
        this.blockProbability = blockProbability;
        this.limit = limit;
        this.blockProvider = blockProvider;
    }

    @Override
    protected FallenTreeDecoratorType<?> type() {
        return NMLFallenTreeDecoratorTypes.CLUSTER_SIDE.get();
    }

    @Override
    public void place(FallenTreeDecorator.Context context) {
        int blocks = 0;
        RandomSource random = context.random();
        if (random.nextFloat() > this.probability) {
            return;
        }
        for (BlockPos pos : Util.shuffledCopy(context.logs(), (RandomSource)random)) {
            for (Direction dir : Direction.Plane.HORIZONTAL.shuffledCopy(random)) {
                if (!context.level().getBlockState(pos.relative(dir)).is(BlockTags.REPLACEABLE) || !(random.nextFloat() < this.blockProbability)) continue;
                BlockState state = this.blockProvider.getState(random, pos.relative(dir));
                if (state.hasProperty((Property)BaseCoralWallFanBlock.FACING)) {
                    state = (BlockState)state.setValue((Property)BaseCoralWallFanBlock.FACING, (Comparable)dir);
                }
                context.setBlock(pos.relative(dir), state);
                ++blocks;
                break;
            }
            if (blocks <= this.limit) continue;
            break;
        }
    }
}

