/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.generation;

import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.worldgen.NMLBiomes;
import com.terraformersmc.biolith.api.surface.SurfaceGeneration;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;

public class NMLSurfaceRules {
    private static final SurfaceRules.RuleSource COARSE_DIRT = NMLSurfaceRules.makeStateRule(Blocks.COARSE_DIRT);
    private static final SurfaceRules.RuleSource PODZOL = NMLSurfaceRules.makeStateRule(Blocks.PODZOL);
    private static final SurfaceRules.RuleSource MUD = NMLSurfaceRules.makeStateRule(Blocks.MUD);
    private static final SurfaceRules.RuleSource SILT = NMLSurfaceRules.makeStateRule((Block)NMLBlocks.SILT.get());
    private static final SurfaceRules.RuleSource WATER = NMLSurfaceRules.makeStateRule(Blocks.WATER);
    private static final SurfaceRules.RuleSource GRAVEL = NMLSurfaceRules.makeStateRule(Blocks.GRAVEL);
    private static final SurfaceRules.RuleSource SNOW_BLOCK = NMLSurfaceRules.makeStateRule(Blocks.SNOW_BLOCK);
    private static final SurfaceRules.RuleSource PACKED_ICE = NMLSurfaceRules.makeStateRule(Blocks.PACKED_ICE);
    private static final SurfaceRules.RuleSource ICE = NMLSurfaceRules.makeStateRule(Blocks.ICE);

    public static void register() {
        SurfaceRules.RuleSource jungle = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.JUNGLE}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)COARSE_DIRT));
        SurfaceRules.RuleSource darkForest = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.DARK_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)PODZOL));
        SurfaceRules.RuleSource autumnalForest = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.AUTUMNAL_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)PODZOL)}));
        SurfaceRules.RuleSource mapleForest = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.MAPLE_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)PODZOL));
        SurfaceRules.RuleSource oldGrowthForest = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.OLD_GROWTH_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)COARSE_DIRT));
        SurfaceRules.RuleSource frozenWoods = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.FROZEN_WOODS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(2.25), (SurfaceRules.RuleSource)SNOW_BLOCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.5), (SurfaceRules.RuleSource)MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)SILT)}));
        SurfaceRules.RuleSource bog = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.BOG}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER))));
        SurfaceRules.RuleSource bayou = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.BAYOU}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)PODZOL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER)))}));
        SurfaceRules.RuleSource darkSwamp = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.DARK_SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.25), (SurfaceRules.RuleSource)PODZOL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER)))}));
        SurfaceRules.RuleSource stonyShore = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.STONY_SHORE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.9), (SurfaceRules.RuleSource)SILT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(1.7), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)SILT), GRAVEL})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(-0.45), (SurfaceRules.RuleSource)GRAVEL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)NMLSurfaceRules.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)GRAVEL))}));
        SurfaceRules.RuleSource caves = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.CAVES}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.state((BlockState)Blocks.STONE.defaultBlockState())}));
        SurfaceRules.RuleSource cave_depths = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{NMLBiomes.CAVE_DEPTHS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.state((BlockState)Blocks.DEEPSLATE.defaultBlockState())}));
        SurfaceGeneration.addOverworldSurfaceRules((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)"rules/overworld"), (SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{jungle, darkForest, autumnalForest, mapleForest, oldGrowthForest, frozenWoods, bog, bayou, darkSwamp, stonyShore}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{caves, cave_depths})))});
    }

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double value) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(value / 8.25), (double)Double.MAX_VALUE);
    }
}

