/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen;

import com.farcr.nomansland.datagen.NMLBlockLootSubProvider;
import com.farcr.nomansland.datagen.NMLDatapackEntriesProvider;
import com.farcr.nomansland.datagen.NMLLanguageProvider;
import com.farcr.nomansland.datagen.tags.NMLBiomeTagsProvider;
import com.farcr.nomansland.datagen.tags.NMLBlockTagsProvider;
import com.farcr.nomansland.datagen.tags.NMLItemTagsProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="nomansland")
public class DataGenEvents {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        boolean server = event.includeServer();
        boolean client = event.includeClient();
        generator.addProvider(server, (DataProvider)new LootTableProvider(generator.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(NMLBlockLootSubProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(server, (DataProvider)new NMLBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        BlockTagsProvider blockTagsProvider = (BlockTagsProvider)generator.addProvider(server, (DataProvider)new NMLBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new NMLItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(client, (DataProvider)new NMLLanguageProvider(packOutput));
        generator.addProvider(server, (DataProvider)new NMLDatapackEntriesProvider(packOutput, lookupProvider));
    }
}

