/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen;

import com.farcr.nomansland.common.registry.worldgen.NMLPlacedFeatures;
import com.farcr.nomansland.common.world.biomemodifiers.ChangeColorsBiomeModifier;
import com.farcr.nomansland.common.world.biomemodifiers.ChangeMusicBiomeModifier;
import com.farcr.nomansland.common.world.biomemodifiers.ChangeSpawnsBiomeModifier;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class NMLDatapackEntriesProvider
extends DatapackBuiltinEntriesProvider {
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, bootstrap -> {
        HolderGetter biomes = bootstrap.lookup(Registries.BIOME);
        HolderGetter placedFeatures = bootstrap.lookup(Registries.PLACED_FEATURE);
        HolderGetter entityTypes = (HolderGetter)bootstrap.registryLookup(Registries.ENTITY_TYPE).orElseThrow();
        GenerationStep.Decoration vegetalDecoration = GenerationStep.Decoration.VEGETAL_DECORATION;
        NMLDatapackEntriesProvider.addFeatures("cactus_features", (BootstrapContext<BiomeModifier>)bootstrap, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(NMLPlacedFeatures.PATCH_BARREL_CACTUS_DESERT), placedFeatures.getOrThrow(NMLPlacedFeatures.PATCH_SUCCULENT_DESERT), placedFeatures.getOrThrow(NMLPlacedFeatures.ALL_TULIPS)}));
        NMLDatapackEntriesProvider.addFeatures("beachgrass", (BootstrapContext<BiomeModifier>)bootstrap, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(NMLPlacedFeatures.PATCH_BEACHGRASS)}));
        NMLDatapackEntriesProvider.addFeatures("silt", (BootstrapContext<BiomeModifier>)bootstrap, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(NMLPlacedFeatures.ORE_SILT)}), GenerationStep.Decoration.UNDERGROUND_ORES);
        NMLDatapackEntriesProvider.removeFeatures("dirt_ore", (BootstrapContext<BiomeModifier>)bootstrap, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(OrePlacements.ORE_DIRT)}));
        HolderSet.Named badlands = biomes.getOrThrow(Tags.Biomes.IS_BADLANDS);
        NMLDatapackEntriesProvider.changeBiome("badlands", (BootstrapContext<BiomeModifier>)bootstrap, new ChangeColorsBiomeModifier((HolderSet<Biome>)badlands, 15322281, 4106959, 3048361, 11128544), null, new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)badlands, List.of(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 15, 2, 8), new MobSpawnSettings.SpawnerData(EntityType.HUSK, 100, 4, 4))), new BiomeModifiers.RemoveSpawnsBiomeModifier((HolderSet)badlands, (HolderSet)HolderSet.direct((Holder[])new Holder[]{BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)EntityType.ZOMBIE)})), null);
        HolderSet.Direct bambooJungle = HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.BAMBOO_JUNGLE)});
        NMLDatapackEntriesProvider.changeBiome("bamboo_jungle", (BootstrapContext<BiomeModifier>)bootstrap, new ChangeColorsBiomeModifier((HolderSet<Biome>)bambooJungle, 11071699, 2403207, 1479552, 7194319, 6798649, 6203171), new ChangeMusicBiomeModifier((HolderSet<Biome>)bambooJungle, new Music((Holder)SoundEvents.MUSIC_BIOME_JUNGLE, 12000, 24000, false)), new ChangeSpawnsBiomeModifier((HolderSet<Biome>)bambooJungle, List.of(new MobSpawnSettings.SpawnerData(EntityType.OCELOT, 8, 1, 3), new MobSpawnSettings.SpawnerData(EntityType.PANDA, 80, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.PIG, 16, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 14, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.COW, 6, 4, 4))), new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)bambooJungle, List.of(new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 15, 2, 8), new MobSpawnSettings.SpawnerData(EntityType.HUSK, 100, 4, 4))), new BiomeModifiers.RemoveSpawnsBiomeModifier((HolderSet)bambooJungle, (HolderSet)HolderSet.direct((Holder[])new Holder[]{BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)EntityType.SHEEP)})), new BiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)bambooJungle, (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(VegetationPlacements.PATCH_PUMPKIN)}), Set.of(vegetalDecoration)));
        HolderSet.Named beach = biomes.getOrThrow(Tags.Biomes.IS_BEACH);
        NMLDatapackEntriesProvider.changeBiome("beach", (BootstrapContext<BiomeModifier>)bootstrap, new ChangeColorsBiomeModifier((HolderSet<Biome>)beach, 12906239, 3902136, 2388383, 7715315, 9680231, 8960833), null, null, null, new BiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)beach, (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(VegetationPlacements.PATCH_GRASS_BADLANDS), placedFeatures.getOrThrow(VegetationPlacements.FLOWER_DEFAULT)}), Set.of(vegetalDecoration)));
        HolderSet.Named desert = biomes.getOrThrow(Tags.Biomes.IS_DESERT);
        NMLDatapackEntriesProvider.changeBiome("desert", (BootstrapContext<BiomeModifier>)bootstrap, new ChangeColorsBiomeModifier((HolderSet<Biome>)desert, 15527891, 4106959, 3048361, 12113081, 14663027, 12762457), null, new ChangeSpawnsBiomeModifier((HolderSet<Biome>)desert, List.of(new MobSpawnSettings.SpawnerData(EntityType.HUSK, 100, 4, 4), new MobSpawnSettings.SpawnerData(EntityType.ZOMBIE_VILLAGER, 5, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 20, 2, 8))), new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)desert, List.of(new MobSpawnSettings.SpawnerData(EntityType.CAMEL, 20, 2, 8))), new BiomeModifiers.RemoveSpawnsBiomeModifier((HolderSet)desert, (HolderSet)HolderSet.direct((Holder[])new Holder[]{BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)EntityType.ZOMBIE)})), new BiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)desert, (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(VegetationPlacements.PATCH_SUGAR_CANE_DESERT), placedFeatures.getOrThrow(VegetationPlacements.PATCH_PUMPKIN)}), Set.of(vegetalDecoration)));
    });

    public static void changeBiome(String name, BootstrapContext<BiomeModifier> bootstrap, @Nullable ChangeColorsBiomeModifier changeColors, @Nullable ChangeMusicBiomeModifier changeMusic, @Nullable ChangeSpawnsBiomeModifier changeSpawns, @Nullable BiomeModifiers.AddSpawnsBiomeModifier addSpawns, @Nullable BiomeModifiers.RemoveSpawnsBiomeModifier removeSpawns, @Nullable BiomeModifiers.RemoveFeaturesBiomeModifier removeFeatures) {
        if (changeColors != null) {
            bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)(name + "/change_color"))), (Object)changeColors);
        }
        if (changeMusic != null) {
            bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)(name + "/change_music"))), (Object)changeMusic);
        }
        if (changeSpawns != null) {
            bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)(name + "/change_spawns"))), (Object)changeSpawns);
        }
        if (addSpawns != null) {
            bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)(name + "/add_spawns"))), (Object)addSpawns);
        }
        if (removeSpawns != null) {
            bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)(name + "/remove_spawns"))), (Object)removeSpawns);
        }
        if (removeFeatures != null) {
            bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)(name + "/remove_features"))), (Object)removeFeatures);
        }
    }

    public static void changeBiome(String name, BootstrapContext<BiomeModifier> bootstrap, @Nullable ChangeColorsBiomeModifier changeColors, @Nullable ChangeSpawnsBiomeModifier changeSpawns, @Nullable BiomeModifiers.AddSpawnsBiomeModifier addSpawns, @Nullable BiomeModifiers.RemoveSpawnsBiomeModifier removeSpawns, @Nullable BiomeModifiers.RemoveFeaturesBiomeModifier removeFeatures) {
        NMLDatapackEntriesProvider.changeBiome(name, bootstrap, changeColors, null, changeSpawns, addSpawns, removeSpawns, removeFeatures);
    }

    public static void addFeatures(String name, BootstrapContext<BiomeModifier> bootstrap, HolderSet<PlacedFeature> features, GenerationStep.Decoration step) {
        bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)("add_" + name))), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)bootstrap.lookup(Registries.BIOME).getOrThrow(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)("feature_addition/has_" + name)))), features, step));
    }

    public static void addFeatures(String name, BootstrapContext<BiomeModifier> bootstrap, HolderSet<PlacedFeature> features) {
        NMLDatapackEntriesProvider.addFeatures(name, bootstrap, features, GenerationStep.Decoration.VEGETAL_DECORATION);
    }

    public static void removeFeatures(String name, BootstrapContext<BiomeModifier> bootstrap, HolderSet<PlacedFeature> features) {
        bootstrap.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)("remove_" + name))), (Object)BiomeModifiers.RemoveFeaturesBiomeModifier.allSteps((HolderSet)bootstrap.lookup(Registries.BIOME).getOrThrow(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)("feature_removal/no_" + name)))), features));
    }

    public NMLDatapackEntriesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("nomansland"));
    }
}

