/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen.tags;

import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class NMLItemTagsProvider
extends ItemTagsProvider {
    public NMLItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "nomansland", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (NMLBlocks.Woodset woodset : NMLBlocks.WOODSETS) {
            this.tag(ItemTags.SIGNS).add((Object)woodset.sign().item());
            this.tag(ItemTags.HANGING_SIGNS).add((Object)woodset.hangingSign().item());
            this.tag(ItemTags.PLANKS).add((Object)woodset.planks().item());
            this.tag(Tags.Items.BOOKSHELVES).add((Object)woodset.bookshelf().item());
            this.tag(Tags.Items.FENCE_GATES_WOODEN).add((Object)woodset.fenceGate().item());
            this.tag(Tags.Items.FENCES_WOODEN).add((Object)woodset.fence().item());
            this.tag(ItemTags.WOODEN_STAIRS).add((Object)woodset.stairs().item());
            this.tag(ItemTags.WOODEN_BUTTONS).add((Object)woodset.button().item());
            this.tag(ItemTags.WOODEN_DOORS).add((Object)woodset.door().item());
            this.tag(ItemTags.WOODEN_SLABS).add((Object)woodset.slab().item());
            this.tag(ItemTags.WOODEN_PRESSURE_PLATES).add((Object)woodset.pressurePlate().item());
            this.tag(ItemTags.WOODEN_TRAPDOORS).add((Object)woodset.trapdoor().item());
            this.tag(ItemTags.LOGS).add((Object)woodset.log().item());
            this.tag(Tags.Items.STRIPPED_LOGS).add((Object)woodset.strippedLog().item());
            this.tag(Tags.Items.STRIPPED_WOODS).add((Object)woodset.strippedWood().item());
        }
        this.tag(ItemTags.LOGS_THAT_BURN).addTags(new TagKey[]{NMLTags.MAPLE_LOGS.itemTag(), NMLTags.PINE_LOGS.itemTag(), NMLTags.WALNUT_LOGS.itemTag(), NMLTags.WILLOW_LOGS.itemTag()});
    }

    @SafeVarargs
    protected final void addToTags(Item item, TagKey<Item> ... itemTags) {
        Arrays.stream(itemTags).toList().forEach(itemTag -> this.tag((TagKey)itemTag).add((Object)item));
    }

    @SafeVarargs
    protected final void addToTags(TagKey<Item> item, TagKey<Item> ... itemTags) {
        Arrays.stream(itemTags).toList().forEach(itemTag -> this.tag((TagKey)itemTag).addTag(item));
    }
}

