/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.ambience;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public enum WeatherState {
    CLEAR(false, false, false, false),
    RAIN(true, false, false, true),
    THUNDER(true, true, false, true),
    SNOW(true, false, true, true),
    THUNDER_SNOW(true, true, true, true),
    DESERT_RAIN(true, false, false, false),
    DESERT_THUNDERSTORM(true, true, false, false);

    public final boolean inclement;
    public final boolean lightning;
    public final boolean snowy;
    public final boolean precipitation;

    private WeatherState(boolean inclement, boolean lightning, boolean snowy, boolean precipitation) {
        this.inclement = inclement;
        this.lightning = lightning;
        this.snowy = snowy;
        this.precipitation = precipitation;
    }

    public static WeatherState fromWorld(Level level, BlockPos pos) {
        if (!level.dimensionType().natural() || !level.dimensionType().hasSkyLight() || level.dimensionType().hasCeiling()) {
            return CLEAR;
        }
        Biome biome = (Biome)level.getBiome(pos).value();
        if (!level.isRaining()) {
            return CLEAR;
        }
        Biome.Precipitation precipitation = biome.getPrecipitationAt(pos);
        boolean lightning = level.isThundering();
        if (precipitation == Biome.Precipitation.RAIN) {
            return lightning ? THUNDER : RAIN;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            return lightning ? THUNDER_SNOW : SNOW;
        }
        if (precipitation == Biome.Precipitation.NONE) {
            return lightning ? DESERT_THUNDERSTORM : DESERT_RAIN;
        }
        return CLEAR;
    }
}

