/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.ambience.fogmodifiers;

import com.farcr.nomansland.client.ambience.FogModifierHandler;
import com.farcr.nomansland.client.ambience.fogmodifiers.FogModifier;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class FogModifierInstance {
    public final FogModifier modifier;
    private boolean active;
    private float interpolationFactor;

    public FogModifierInstance(FogModifier modifier) {
        this.modifier = modifier;
    }

    public void tick() {
        this.interpolationFactor = Mth.lerp((float)this.modifier.getInterpolationSpeed(), (float)this.interpolationFactor, (float)(this.active ? 1.0f : 0.0f));
    }

    public void update(FogModifierHandler.FogContext context) {
        this.active = this.modifier.active(context) && context.darknessFactor() == 0.0f;
    }

    public float getFogStartMultiplier() {
        return Mth.lerp((float)this.interpolationFactor, (float)1.0f, (float)this.modifier.getFogStartMultiplier());
    }

    public float getFogEndMultiplier() {
        return Mth.lerp((float)this.interpolationFactor, (float)1.0f, (float)this.modifier.getFogEndMultiplier());
    }

    public float getFogStartAddend() {
        return Mth.lerp((float)this.interpolationFactor, (float)0.0f, (float)this.modifier.getFogStartAddend());
    }

    public float getFogEndAddend() {
        return Mth.lerp((float)this.interpolationFactor, (float)0.0f, (float)this.modifier.getFogEndAddend());
    }

    public void multiplyFogColors(Vector3f fogColors) {
        fogColors.mul(Mth.lerp((float)this.interpolationFactor, (float)1.0f, (float)this.modifier.getFogRedMultiplier()), Mth.lerp((float)this.interpolationFactor, (float)1.0f, (float)this.modifier.getFogGreenMultiplier()), Mth.lerp((float)this.interpolationFactor, (float)1.0f, (float)this.modifier.getFogBlueMultiplier()));
    }
}

