/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.event;

import com.farcr.nomansland.NoMansLand;
import com.farcr.nomansland.client.NMLModelLayers;
import com.farcr.nomansland.client.ambience.AmbienceHandler;
import com.farcr.nomansland.client.model.AncientBronzeMaskModel;
import com.farcr.nomansland.client.model.BillhookBassModel;
import com.farcr.nomansland.client.model.BuriedModel;
import com.farcr.nomansland.client.model.deer.DeerModel;
import com.farcr.nomansland.client.model.goose.GooseModel;
import com.farcr.nomansland.client.model.moose.MooseModel;
import com.farcr.nomansland.client.model.tortoise.TortoiseModel;
import com.farcr.nomansland.client.model.tortoise.TortoiseShellModel;
import com.farcr.nomansland.client.particle.BubbleParticle;
import com.farcr.nomansland.client.particle.BubblePopParticle;
import com.farcr.nomansland.client.particle.CaveDustParticle;
import com.farcr.nomansland.client.particle.EmbersParticle;
import com.farcr.nomansland.client.particle.FallingParticle;
import com.farcr.nomansland.client.particle.FlameParticle;
import com.farcr.nomansland.client.particle.FluidFallingParticle;
import com.farcr.nomansland.client.particle.FluidLandParticle;
import com.farcr.nomansland.client.particle.FluidSplashingParticle;
import com.farcr.nomansland.client.particle.SculkAmbienceParticle;
import com.farcr.nomansland.client.particle.TranslucentDustParticle;
import com.farcr.nomansland.client.particle.TranslucentDustParticleOptions;
import com.farcr.nomansland.client.renderer.BillhookBassRenderer;
import com.farcr.nomansland.client.renderer.DeerRenderer;
import com.farcr.nomansland.client.renderer.ExplosiveRenderer;
import com.farcr.nomansland.client.renderer.FatJointRenderer;
import com.farcr.nomansland.client.renderer.FirebombRenderer;
import com.farcr.nomansland.client.renderer.GooseRenderer;
import com.farcr.nomansland.client.renderer.IncendiaryArrowRenderer;
import com.farcr.nomansland.client.renderer.InkBombRenderer;
import com.farcr.nomansland.client.renderer.LivingUrnRenderer;
import com.farcr.nomansland.client.renderer.MooseRenderer;
import com.farcr.nomansland.client.renderer.TortoiseRenderer;
import com.farcr.nomansland.common.integration.Mods;
import com.farcr.nomansland.common.integration.nirvana.NirvanaIntegration;
import com.farcr.nomansland.common.registry.NMLFluids;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.farcr.nomansland.common.registry.items.NMLItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="nomansland", value={Dist.CLIENT})
public class ClientSetupEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        AmbienceHandler.FOG_MODIFIER_HANDLER.fillFogModifiers();
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)NoMansLand.location("entity/firebomb")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)NoMansLand.location("entity/ink_bomb")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)NoMansLand.location("entity/explosive")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)NoMansLand.location("entity/living_urn")));
        if (Mods.NIRVANA.isLoaded()) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)NoMansLand.location("entity/fat_joint")));
        }
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(NMLEntities.BILLHOOK_BASS.get(), BillhookBassRenderer::new);
        event.registerEntityRenderer(NMLEntities.DEER.get(), DeerRenderer::new);
        event.registerEntityRenderer(NMLEntities.GOOSE.get(), GooseRenderer::new);
        event.registerEntityRenderer(NMLEntities.MOOSE.get(), MooseRenderer::new);
        event.registerEntityRenderer(NMLEntities.TORTOISE.get(), TortoiseRenderer::new);
        event.registerEntityRenderer(NMLEntities.FIREBOMB.get(), FirebombRenderer::new);
        event.registerEntityRenderer(NMLEntities.INK_BOMB.get(), InkBombRenderer::new);
        event.registerEntityRenderer(NMLEntities.EXPLOSIVE.get(), ExplosiveRenderer::new);
        event.registerEntityRenderer(NMLEntities.LIVING_URN.get(), LivingUrnRenderer::new);
        if (Mods.NIRVANA.isLoaded()) {
            event.registerEntityRenderer(NirvanaIntegration.FAT_JOINT.get(), FatJointRenderer::new);
        }
        event.registerEntityRenderer(NMLEntities.INCENDIARY_ARROW.get(), IncendiaryArrowRenderer::new);
        event.registerEntityRenderer(NMLEntities.EMBER.get(), NoopRenderer::new);
        event.registerEntityRenderer(NMLEntities.LINGERING_CLOUD.get(), NoopRenderer::new);
        event.registerEntityRenderer(NMLEntities.INK_CLOUD.get(), NoopRenderer::new);
        event.registerEntityRenderer(NMLEntities.PACIFIED_CLOUD.get(), NoopRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(NMLModelLayers.MOOSE_LAYER, MooseModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.BURIED_LAYER, BuriedModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.BASS_LAYER, BillhookBassModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.DEER_LAYER, DeerModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.GOOSE_LAYER, GooseModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.TORTOISE_LAYER, TortoiseModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.TORTOISE_SHELL_LAYER, TortoiseShellModel::createBodyLayer);
        event.registerLayerDefinition(NMLModelLayers.ANCIENT_BRONZE_MASK_LAYER, AncientBronzeMaskModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_RESIN_OIL = NoMansLand.location("block/fluid/resin_oil");
            private static final ResourceLocation FLOWING_RESIN_OIL = NoMansLand.location("block/fluid/flowing_resin_oil");

            public ResourceLocation getStillTexture() {
                return STILL_RESIN_OIL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_RESIN_OIL;
            }
        }, new FluidType[]{NMLFluids.RESIN_OIL_TYPE.get()});
        event.registerItem(new IClientItemExtensions(){

            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return new TortoiseShellModel(Minecraft.getInstance().getEntityModels().bakeLayer(NMLModelLayers.TORTOISE_SHELL_LAYER));
            }

            public void setupModelAnimations(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, Model model, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
                TortoiseShellModel tortoiseShellModel = (TortoiseShellModel)model;
                if (livingEntity.isCrouching()) {
                    tortoiseShellModel.tortoiseShell.xRot = 0.5f;
                    tortoiseShellModel.tortoiseShell.z = 10.5f;
                }
            }
        }, new Item[]{(Item)NMLItems.TORTOISE_SHELL.get()});
        event.registerItem(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(@NotNull LivingEntity entity, @NotNull ItemStack stack, @NotNull EquipmentSlot slot, @NotNull HumanoidModel<?> original) {
                if (slot != EquipmentSlot.HEAD) {
                    return original;
                }
                ModelPart baked = Minecraft.getInstance().getEntityModels().bakeLayer(NMLModelLayers.ANCIENT_BRONZE_MASK_LAYER);
                AncientBronzeMaskModel model = new AncientBronzeMaskModel(baked);
                ClientHooks.copyModelProperties(original, model);
                return model;
            }
        }, new Item[]{(Item)NMLItems.ANCIENT_BRONZE_MASK.get()});
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)NMLParticleTypes.PALE_CHERRY_LEAVES.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FallingParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.CAVE_DUST.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new CaveDustParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.RESIN_DROPLET.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidFallingParticle(clientLevel, d, e, f, sprites, NMLParticleTypes.RESIN_DROPLET_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.RESIN_DROPLET_FLAT.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidLandParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MAPLE_SYRUP_DROPLET.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidFallingParticle(clientLevel, d, e, f, sprites, NMLParticleTypes.MAPLE_SYRUP_DROPLET_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MAPLE_SYRUP_DROPLET_FLAT.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidLandParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.OIL.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidFallingParticle(clientLevel, d, e, f, sprites, NMLParticleTypes.OIL_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.OIL_SPLASH.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidSplashingParticle(clientLevel, d, e, f, g, h, i, sprites, NMLParticleTypes.OIL_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.OIL_FLAT.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidLandParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.RESIN_OIL_BUBBLE.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new BubbleParticle(clientLevel, d, e, f, g, h, i, sprites, NMLParticleTypes.RESIN_OIL_BUBBLE_POP));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.RESIN_OIL_BUBBLE_POP.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new BubblePopParticle(clientLevel, d, e, f, g, h, i, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.SCULK_AMBIENCE.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new SculkAmbienceParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MALEVOLENT_EMBERS.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new EmbersParticle(clientLevel, d, e, f, g, h, i, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MALEVOLENT_FLAME.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FlameParticle(clientLevel, d, e, f, g, h, i, sprites));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MILK_DROPLET.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidFallingParticle(clientLevel, d, e, f, sprites, NMLParticleTypes.MILK_DROPLET_FLAT));
        event.registerSpriteSet((ParticleType)NMLParticleTypes.MILK_DROPLET_FLAT.get(), sprites -> (simpleParticleType, clientLevel, d, e, f, g, h, i) -> new FluidLandParticle(clientLevel, d, e, f, sprites));
        event.registerSpriteSet(NMLParticleTypes.TRANSLUCENT_DUST.get(), sprites -> (translucentDustParticleOptions, clientLevel, d, e, f, g, h, i) -> new TranslucentDustParticle(clientLevel, d, e, f, g, h, i, (TranslucentDustParticleOptions)translucentDustParticleOptions, sprites));
    }
}

