/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.model;

import com.farcr.nomansland.common.entity.billhook_bass.BillhookBass;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BillhookBassModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart tail;
    private final ModelPart tailFin;
    private final ModelPart jaw;

    public BillhookBassModel(ModelPart root) {
        this.root = root;
        this.tail = root.getChild("body").getChild("tail");
        this.tailFin = this.tail.getChild("tail_fin");
        this.jaw = root.getChild("body").getChild("head").getChild("jaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.5f, -5.5f, 4.0f, 7.0f, 11.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)8.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 4.0f, 3.0f).texOffs(19, 0).addBox(-1.0f, -2.0f, -8.0f, 2.0f, 2.0f, 5.0f), PartPose.offset((float)0.0f, (float)1.5f, (float)-5.5f));
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(28, 0).addBox(-0.5f, -1.0f, -3.0f, 1.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)-3.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(33, 0).addBox(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)-0.5f, (float)5.5f));
        tail.addOrReplaceChild("tail_fin", CubeListBuilder.create().texOffs(30, 4).addBox(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.5f, (float)5.0f));
        body.addOrReplaceChild("dorsal_fin1", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, -2.0f, -2.0f, 0.0f, 2.0f, 4.0f), PartPose.offset((float)0.0f, (float)-3.5f, (float)-0.5f));
        body.addOrReplaceChild("dorsal_fin2", CubeListBuilder.create().texOffs(0, 5).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 4.0f), PartPose.offset((float)0.0f, (float)-3.5f, (float)3.5f));
        body.addOrReplaceChild("right_anal_fin", CubeListBuilder.create().texOffs(19, 3).mirror().addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)3.5f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.2618f));
        body.addOrReplaceChild("left_anal_fin", CubeListBuilder.create().texOffs(19, 5).addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)1.0f, (float)3.5f, (float)3.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        body.addOrReplaceChild("right_pectoral_fin", CubeListBuilder.create().texOffs(5, 0).mirror().addBox(-2.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)3.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        body.addOrReplaceChild("left_pectoral_fin", CubeListBuilder.create().texOffs(5, 0).addBox(0.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)3.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)1.0472f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 1.0f;
        float f1 = 1.0f;
        if (!entity.isInWater()) {
            f = 1.3f;
            f1 = 1.7f;
        }
        this.tailFin.yRot = -f * 0.25f * Mth.sin((float)(f1 * 0.6f * ageInTicks));
        this.tail.yRot = this.tailFin.yRot / 2.0f;
        if (((BillhookBass)((Object)entity)).isAngry()) {
            this.jaw.xRot = -f * 0.2f * Mth.sin((float)(f1 * 0.7f * ageInTicks));
            this.jaw.z = -2.5f;
        } else {
            this.jaw.xRot = 0.0f;
            this.jaw.z = -3.0f;
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

