/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;

public class FlameParticle
extends RisingParticle {
    public FlameParticle(ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet spriteSet) {
        super(level, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        this.setSprite(spriteSet.get(this.random.nextInt(4), 4));
    }

    public void move(double pX, double pY, double pZ) {
        this.setBoundingBox(this.getBoundingBox().move(pX, pY, pZ));
        this.setLocationFromBoundingbox();
    }

    public float getQuadSize(float pScaleFactor) {
        float $$1 = ((float)this.age + pScaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - $$1 * $$1 * 0.5f);
    }

    public int getLightColor(float pPartialTick) {
        float $$1 = ((float)this.age + pPartialTick) / (float)this.lifetime;
        $$1 = Mth.clamp((float)$$1, (float)0.0f, (float)1.0f);
        int $$2 = super.getLightColor(pPartialTick);
        int $$3 = $$2 & 0xFF;
        int $$4 = $$2 >> 16 & 0xFF;
        if (($$3 += (int)($$1 * 15.0f * 16.0f)) > 240) {
            $$3 = 240;
        }
        return $$3 | $$4 << 16;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }
}

