/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.particle;

import com.farcr.nomansland.common.registry.NMLSounds;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class FluidFallingParticle
extends TextureSheetParticle {
    private final Supplier<SimpleParticleType> flatParticle;

    public FluidFallingParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, Supplier<SimpleParticleType> flatParticle) {
        super(level, x, y, z);
        this.setSprite(spriteSet.get(this.random.nextInt(4), 4));
        this.gravity = 0.01f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.flatParticle = flatParticle;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void postMoveUpdate() {
        if (this.onGround) {
            float offset = (float)this.random.nextInt(-10, 10) * 0.01f;
            if (this.flatParticle != null) {
                this.level.addParticle((ParticleOptions)this.flatParticle.get(), this.x + (double)offset * Math.random(), this.y, this.z + (double)offset * Math.random(), 0.0, 0.0, 0.0);
            }
            float volume = Mth.randomBetween((RandomSource)this.random, (float)0.3f, (float)1.0f);
            this.level.playLocalSound(this.x, this.y, this.z, (SoundEvent)NMLSounds.DROPLET_FALLS.get(), SoundSource.BLOCKS, volume, 1.0f, false);
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }
}

