/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.particle;

import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class FluidSplashingParticle
extends TextureSheetParticle {
    private static final RandomSource RANDOM = RandomSource.create();
    private final Supplier<SimpleParticleType> flatParticle;

    public FluidSplashingParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, Supplier<SimpleParticleType> flatParticle) {
        super(level, x, y, z, (0.5 - RANDOM.nextDouble()) * 1.25, ySpeed * 0.5, (0.5 - RANDOM.nextDouble()) * 1.25);
        this.setSprite(spriteSet.get(this.random.nextInt(4), 4));
        this.gravity = 0.02f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.flatParticle = flatParticle;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void postMoveUpdate() {
        if (this.onGround) {
            float offset = (float)this.random.nextInt(-10, 10) * 0.01f;
            if (this.flatParticle != null) {
                this.level.addParticle((ParticleOptions)this.flatParticle.get(), this.x + (double)offset * Math.random(), this.y, this.z + (double)offset * Math.random(), 0.0, 0.0, 0.0);
            }
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }
}

