/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.renderer;

import com.farcr.nomansland.NoMansLand;
import com.farcr.nomansland.common.entity.IncendiaryArrow;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.projectile.AbstractArrow;

public class IncendiaryArrowRenderer
extends ArrowRenderer<IncendiaryArrow> {
    public static final ResourceLocation TEXTURE = NoMansLand.location("textures/entity/incendiary_arrow.png");

    public IncendiaryArrowRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(IncendiaryArrow entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((AbstractArrow)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        float shake = (float)entity.shakeTime - partialTicks;
        if (shake > 0.0f) {
            float shakeRot = -Mth.sin((float)(shake * 3.0f)) * shake;
            poseStack.mulPose(Axis.ZP.rotationDegrees(shakeRot));
        }
        poseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.scale(0.05625f, 0.05625f, 0.05625f);
        poseStack.translate(0.0f, -2.5f, 4.0f);
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
        PoseStack.Pose pose = poseStack.last();
        float U = 0.03125f;
        float V = 0.03125f;
        this.vertex(pose, consumer, -1, 3.5f, -7, 6.0f * U, 16.0f * V, 0, 0, -1, packedLight);
        this.vertex(pose, consumer, 1, 3.5f, -7, 8.0f * U, 16.0f * V, 0, 0, -1, packedLight);
        this.vertex(pose, consumer, 1, 1.5f, -7, 8.0f * U, 18.0f * V, 0, 0, -1, packedLight);
        this.vertex(pose, consumer, -1, 1.5f, -7, 6.0f * U, 18.0f * V, 0, 0, -1, packedLight);
        this.vertex(pose, consumer, -1, 1.5f, -1, 14.0f * U, 18.0f * V, 0, 0, 1, packedLight);
        this.vertex(pose, consumer, 1, 1.5f, -1, 16.0f * U, 18.0f * V, 0, 0, 1, packedLight);
        this.vertex(pose, consumer, 1, 3.5f, -1, 16.0f * U, 16.0f * V, 0, 0, 1, packedLight);
        this.vertex(pose, consumer, -1, 3.5f, -1, 14.0f * U, 16.0f * V, 0, 0, 1, packedLight);
        this.vertex(pose, consumer, -1, 3.5f, -7, 8.0f * U, 16.0f * V, 0, 1, 0, packedLight);
        this.vertex(pose, consumer, -1, 3.5f, -1, 8.0f * U, 10.0f * V, 0, 1, 0, packedLight);
        this.vertex(pose, consumer, 1, 3.5f, -1, 6.0f * U, 10.0f * V, 0, 1, 0, packedLight);
        this.vertex(pose, consumer, 1, 3.5f, -7, 6.0f * U, 16.0f * V, 0, 1, 0, packedLight);
        this.vertex(pose, consumer, -1, 1.5f, -7, 8.0f * U, 16.0f * V, 0, -1, 0, packedLight);
        this.vertex(pose, consumer, 1, 1.5f, -7, 10.0f * U, 16.0f * V, 0, -1, 0, packedLight);
        this.vertex(pose, consumer, 1, 1.5f, -1, 10.0f * U, 10.0f * V, 0, -1, 0, packedLight);
        this.vertex(pose, consumer, -1, 1.5f, -1, 8.0f * U, 10.0f * V, 0, -1, 0, packedLight);
        this.vertex(pose, consumer, -1, 1.5f, -7, 8.0f * U, 18.0f * V, -1, 0, 0, packedLight);
        this.vertex(pose, consumer, -1, 1.5f, -1, 14.0f * U, 18.0f * V, -1, 0, 0, packedLight);
        this.vertex(pose, consumer, -1, 3.5f, -1, 14.0f * U, 16.0f * V, -1, 0, 0, packedLight);
        this.vertex(pose, consumer, -1, 3.5f, -7, 8.0f * U, 16.0f * V, -1, 0, 0, packedLight);
        this.vertex(pose, consumer, 1, 3.5f, -7, 6.0f * U, 16.0f * V, 1, 0, 0, packedLight);
        this.vertex(pose, consumer, 1, 3.5f, -1, 0.0f * U, 16.0f * V, 1, 0, 0, packedLight);
        this.vertex(pose, consumer, 1, 1.5f, -1, 0.0f * U, 18.0f * V, 1, 0, 0, packedLight);
        this.vertex(pose, consumer, 1, 1.5f, -7, 6.0f * U, 18.0f * V, 1, 0, 0, packedLight);
        poseStack.popPose();
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer consumer, int x, float y, int z, float u, float v, int normalX, int normalY, int normalZ, int packedLight) {
        consumer.addVertex(pose, (float)x, y, (float)z).setColor(-1).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)normalX, (float)normalZ, (float)normalY);
    }

    public ResourceLocation getTextureLocation(IncendiaryArrow incendiaryArrow) {
        return TEXTURE;
    }
}

