/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CaveFoliageBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<CaveFoliageBlock> CODEC = CaveFoliageBlock.simpleCodec(CaveFoliageBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public CaveFoliageBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.DIRT) || state.is(BlockTags.BASE_STONE_OVERWORLD) || state.getBlock() instanceof FarmBlock;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        for (BlockPos pos : BlockPos.betweenClosed((int)(x - 3), (int)(y - 1), (int)(z - 3), (int)(x + 3), (int)(y + 2), (int)(z + 3))) {
            if (!(randomSource.nextFloat() < 0.3f) || !blockState.canSurvive((LevelReader)serverLevel, pos) || !serverLevel.isEmptyBlock(pos)) continue;
            serverLevel.setBlockAndUpdate(pos, blockState);
        }
    }
}

